/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.curator4.com.google.common.collect;

import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.flink.shaded.curator4.com.google.common.annotations.GwtCompatible;
import org.apache.flink.shaded.curator4.com.google.common.annotations.GwtIncompatible;
import org.apache.flink.shaded.curator4.com.google.common.base.Preconditions;
import org.apache.flink.shaded.curator4.com.google.common.collect.CollectSpliterators;
import org.apache.flink.shaded.curator4.com.google.common.collect.ImmutableAsList;
import org.apache.flink.shaded.curator4.com.google.common.collect.ImmutableCollection;
import org.apache.flink.shaded.curator4.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.curator4.com.google.common.collect.ImmutableSet;
import org.apache.flink.shaded.curator4.com.google.common.collect.UnmodifiableIterator;

@GwtCompatible(emulated=true)
abstract class IndexedImmutableSet<E>
extends ImmutableSet<E> {
    IndexedImmutableSet() {
    }

    abstract E get(int var1);

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1297, this::get);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(Object[] dst, int offset) {
        return this.asList().copyIntoArray(dst, offset);
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableAsList<E>(){

            @Override
            public E get(int index) {
                return IndexedImmutableSet.this.get(index);
            }

            @Override
            boolean isPartialView() {
                return IndexedImmutableSet.this.isPartialView();
            }

            @Override
            public int size() {
                return IndexedImmutableSet.this.size();
            }

            @Override
            ImmutableCollection<E> delegateCollection() {
                return IndexedImmutableSet.this;
            }
        };
    }
}

