/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.sling.thumbnails.TransformationHandlerConfig;
import org.apache.sling.thumbnails.extension.TransformationHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={TransformationHandler.class}, immediate=true)
public class RotateHandler
implements TransformationHandler {
    public static final String RESOURCE_TYPE = "sling/thumbnails/transformers/rotate";
    public static final String DEGREES = "degrees";

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public void handle(InputStream inputStream, OutputStream outputStream, TransformationHandlerConfig config) throws IOException {
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
        double degrees = (Double)config.getProperties().get(DEGREES, (Object)0.0);
        builder.rotate(degrees);
        builder.scale(1.0);
        builder.toOutputStream(outputStream);
    }
}

