/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.mount;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.spi.mount.FragmentMatcher;
import org.apache.jackrabbit.oak.spi.mount.Mount;

public final class MountInfo
implements Mount {
    private static final Function<String, String> SANITIZE_PATH = new Function<String, String>(){

        @Override
        public String apply(String input) {
            if (input.endsWith("/") && input.length() > 1) {
                return input.substring(0, input.length() - 1);
            }
            return input;
        }
    };
    private final String name;
    private final boolean readOnly;
    private final String pathFragmentName;
    private final Set<String> pathsSupportingFragments;
    private final NavigableSet<String> includedPaths;

    public MountInfo(String name, boolean readOnly, List<String> pathsSupportingFragments, List<String> includedPaths) {
        this.name = Objects.requireNonNull(name, "Mount name must not be null");
        this.readOnly = readOnly;
        this.pathFragmentName = "oak:mount-" + name;
        this.includedPaths = MountInfo.cleanCopy(includedPaths);
        this.pathsSupportingFragments = Collections.unmodifiableSet(SetUtils.toLinkedSet(pathsSupportingFragments));
    }

    @Override
    public boolean isUnder(String path) {
        String nextPath = this.includedPaths.higher(path = SANITIZE_PATH.apply(path));
        return nextPath != null && PathUtils.isAncestor(path, nextPath);
    }

    @Override
    public boolean isDirectlyUnder(String path) {
        path = SANITIZE_PATH.apply(path);
        for (String nextPath : this.includedPaths) {
            if (!path.equals(PathUtils.getParentPath(nextPath))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMounted(String path) {
        String previousPath;
        if (path.contains(this.pathFragmentName)) {
            String parent = path.substring(0, path.indexOf(this.pathFragmentName));
            if (this.isSupportFragment(parent = parent.substring(0, parent.lastIndexOf(47)))) {
                return true;
            }
        }
        return (previousPath = this.includedPaths.floor(path = SANITIZE_PATH.apply(path))) != null && (previousPath.equals(path) || PathUtils.isAncestor(previousPath, path));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isSupportFragment(String path) {
        String subject = SANITIZE_PATH.apply(path);
        return this.pathsSupportingFragments.stream().map(pattern -> FragmentMatcher.startsWith(pattern, subject)).anyMatch(FragmentMatcher.Result.FULL_MATCH::equals);
    }

    @Override
    public boolean isSupportFragmentUnder(String path) {
        String subject = SANITIZE_PATH.apply(path);
        return this.pathsSupportingFragments.stream().map(pattern -> FragmentMatcher.startsWith(pattern, subject)).anyMatch(r -> r == FragmentMatcher.Result.PARTIAL_MATCH || r == FragmentMatcher.Result.FULL_MATCH);
    }

    @Override
    public String getPathFragmentName() {
        return this.pathFragmentName;
    }

    private static TreeSet<String> cleanCopy(Collection<String> includedPaths) {
        return SetUtils.toTreeSet(IterableUtils.transform(includedPaths, SANITIZE_PATH));
    }

    public Set<String> getPathsSupportingFragments() {
        return Collections.unmodifiableSet(this.pathsSupportingFragments);
    }

    public Set<String> getIncludedPaths() {
        return Collections.unmodifiableSet(this.includedPaths);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String readAttr = this.readOnly ? "r" : "rw";
        pw.print(this.name + "(" + readAttr + ")");
        for (String path : this.includedPaths) {
            pw.printf("\t%s%n", path);
        }
        return sw.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MountInfo other = (MountInfo)obj;
        return this.name.equals(other.name);
    }
}

