/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.ReadOnly;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.TreeTypeAware;
import org.apache.jackrabbit.oak.plugins.tree.impl.AbstractTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutableTree
extends AbstractTree
implements TreeTypeAware,
ReadOnly {
    private final NodeBuilder nodeBuilder;
    private final String name;
    private final ParentProvider parentProvider;
    private String path;
    private TreeType type;

    public ImmutableTree(@NotNull NodeState rootState) {
        this(ParentProvider.ROOT_PROVIDER, "", rootState);
    }

    public ImmutableTree(@NotNull ImmutableTree parent, @NotNull String name, @NotNull NodeState state) {
        this(new DefaultParentProvider(parent), name, state);
    }

    public ImmutableTree(@NotNull ParentProvider parentProvider, @NotNull String name, @NotNull NodeState state) {
        this.nodeBuilder = new ReadOnlyBuilder(state);
        this.name = name;
        this.parentProvider = parentProvider;
    }

    @Override
    @Nullable
    public TreeType getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull TreeType type) {
        this.type = type;
    }

    @Override
    @NotNull
    protected ImmutableTree createChild(@NotNull String name) {
        return new ImmutableTree(this, name, this.nodeBuilder.getNodeState().getChildNode(name));
    }

    @Override
    public boolean isRoot() {
        return "".equals(this.name);
    }

    @Override
    @Nullable
    protected AbstractTree getParentOrNull() {
        return this.parentProvider.getParent();
    }

    @Override
    @NotNull
    protected NodeBuilder getNodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    protected boolean isHidden(@NotNull String name) {
        return false;
    }

    @Override
    @NotNull
    protected String[] getInternalNodeNames() {
        return new String[0];
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.path == null) {
            this.path = super.getPath();
        }
        return this.path;
    }

    @Override
    @NotNull
    public ImmutableTree getChild(@NotNull String name) throws IllegalArgumentException {
        return this.createChild(name);
    }

    @Override
    public boolean remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Tree addChild(@NotNull String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOrderableChildren(boolean enable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean orderBefore(@Nullable String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(@NotNull PropertyState property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setProperty(@NotNull String name, @NotNull T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setProperty(@NotNull String name, @NotNull T value, @NotNull Type<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeProperty(@NotNull String name) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.nodeBuilder.getNodeState());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableTree) {
            ImmutableTree other = (ImmutableTree)o;
            return this.getName().equals(other.getName()) && this.nodeBuilder.getNodeState().equals(other.nodeBuilder.getNodeState());
        }
        return false;
    }

    public static final class DefaultParentProvider
    implements ParentProvider {
        private final ImmutableTree parent;

        DefaultParentProvider(@NotNull ImmutableTree parent) {
            this.parent = parent;
        }

        @Override
        public ImmutableTree getParent() {
            return this.parent;
        }
    }

    public static interface ParentProvider {
        public static final ParentProvider UNSUPPORTED = new ParentProvider(){

            @Override
            public ImmutableTree getParent() {
                throw new UnsupportedOperationException("not supported.");
            }
        };
        public static final ParentProvider ROOT_PROVIDER = new ParentProvider(){

            @Override
            public ImmutableTree getParent() {
                return null;
            }
        };

        @Nullable
        public ImmutableTree getParent();
    }
}

