/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.datastore;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.index.datastore.DataStoreTextWriter;
import org.apache.jackrabbit.oak.plugins.index.fulltext.PreExtractedTextProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={}, name="org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreTextProviderService")
@Designate(ocd=Configuration.class)
public class DataStoreTextProviderService {
    private DataStoreTextWriter textWriter;
    private ServiceRegistration reg;

    @Activate
    private void activate(BundleContext context, Configuration config) throws IOException {
        String dirPath = config.dir();
        Objects.requireNonNull(dirPath, "Directory path not configured via 'dir'");
        File dir = new File(dirPath);
        Validate.checkArgument(dir.exists(), "Directory %s does not exist", dir.getAbsolutePath());
        this.textWriter = new DataStoreTextWriter(dir, true);
        this.reg = context.registerService(PreExtractedTextProvider.class.getName(), (Object)this.textWriter, null);
    }

    @Deactivate
    private void deactivate() throws IOException {
        this.textWriter.close();
        if (this.reg != null) {
            this.reg.unregister();
        }
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak DataStore PreExtractedTextProvider", description="Configures a PreExtractedTextProvider based on extracted text stored on FileSystem")
    static @interface Configuration {
        @AttributeDefinition(name="Path", description="Local file system path where extracted text is stored in files.")
        public String dir();
    }
}

