/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.internal;

import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.collect.Sets;

class InternalSecurityProvider
implements SecurityProvider,
WhiteboardAware {
    private AuthenticationConfiguration authenticationConfiguration;
    private AuthorizationConfiguration authorizationConfiguration;
    private UserConfiguration userConfiguration;
    private PrivilegeConfiguration privilegeConfiguration;
    private PrincipalConfiguration principalConfiguration;
    private TokenConfiguration tokenConfiguration;
    private Whiteboard whiteboard;

    InternalSecurityProvider() {
    }

    @Override
    @NotNull
    public ConfigurationParameters getParameters(@Nullable String name) {
        SecurityConfiguration securityConfiguration = this.getSecurityConfigurationByName(name);
        if (securityConfiguration == null) {
            return ConfigurationParameters.EMPTY;
        }
        return securityConfiguration.getParameters();
    }

    private SecurityConfiguration getSecurityConfigurationByName(String name) {
        if ("org.apache.jackrabbit.oak.authentication".equals(name)) {
            return this.authenticationConfiguration;
        }
        if ("org.apache.jackrabbit.oak.authorization".equals(name)) {
            return this.authorizationConfiguration;
        }
        if ("org.apache.jackrabbit.oak.user".equals(name)) {
            return this.userConfiguration;
        }
        if ("org.apache.jackrabbit.oak.privilege".equals(name)) {
            return this.privilegeConfiguration;
        }
        if ("org.apache.jackrabbit.oak.principal".equals(name)) {
            return this.principalConfiguration;
        }
        if ("org.apache.jackrabbit.oak.authentication.token".equals(name)) {
            return this.tokenConfiguration;
        }
        return null;
    }

    @Override
    @NotNull
    public Iterable<? extends SecurityConfiguration> getConfigurations() {
        return Sets.newHashSet(this.authenticationConfiguration, this.authorizationConfiguration, this.userConfiguration, this.privilegeConfiguration, this.principalConfiguration, this.tokenConfiguration);
    }

    @Override
    @NotNull
    public <T> T getConfiguration(@NotNull Class<T> configurationClass) {
        if (configurationClass == AuthenticationConfiguration.class) {
            return (T)this.authenticationConfiguration;
        }
        if (configurationClass == AuthorizationConfiguration.class) {
            return (T)this.authorizationConfiguration;
        }
        if (configurationClass == UserConfiguration.class) {
            return (T)this.userConfiguration;
        }
        if (configurationClass == PrivilegeConfiguration.class) {
            return (T)this.privilegeConfiguration;
        }
        if (configurationClass == PrincipalConfiguration.class) {
            return (T)this.principalConfiguration;
        }
        if (configurationClass == TokenConfiguration.class) {
            return (T)this.tokenConfiguration;
        }
        throw new IllegalArgumentException("Unsupported security configuration class " + configurationClass);
    }

    @Override
    public void setWhiteboard(@NotNull Whiteboard whiteboard) {
        this.whiteboard = whiteboard;
    }

    @Override
    public Whiteboard getWhiteboard() {
        return this.whiteboard;
    }

    public void setAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public void setAuthorizationConfiguration(AuthorizationConfiguration authorizationConfiguration) {
        this.authorizationConfiguration = authorizationConfiguration;
    }

    public void setUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    public void setPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = privilegeConfiguration;
    }

    public void setPrincipalConfiguration(PrincipalConfiguration principalConfiguration) {
        this.principalConfiguration = principalConfiguration;
    }

    public void setTokenConfiguration(TokenConfiguration tokenConfiguration) {
        this.tokenConfiguration = tokenConfiguration;
    }
}

