/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.sitemap.SitemapGeneratorManager;
import org.apache.sling.sitemap.spi.generator.SitemapGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SitemapGeneratorManager.class})
@Designate(ocd=Configuration.class)
public class SitemapGeneratorManagerImpl
implements SitemapGeneratorManager {
    private static final Logger LOG = LoggerFactory.getLogger(SitemapGeneratorManagerImpl.class);
    @Reference(service=SitemapGenerator.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policyOption=ReferencePolicyOption.GREEDY)
    private List<SitemapGenerator> generators;
    private boolean allOnDemand;

    @Activate
    protected void activate(Configuration configuration) {
        Collections.reverse(this.generators);
        this.allOnDemand = configuration.allOnDemand();
    }

    @Override
    @Nullable
    public SitemapGenerator getGenerator(@NotNull Resource sitemapRoot, @NotNull String name) {
        for (SitemapGenerator generator : this.generators) {
            HashSet<String> providedNames = new HashSet<String>(generator.getNames(sitemapRoot));
            if (!providedNames.contains(name)) continue;
            return generator;
        }
        return null;
    }

    @Override
    public Set<String> getNames(@NotNull Resource sitemapRoot) {
        return this.getGenerators(sitemapRoot).keySet();
    }

    @Override
    @NotNull
    public Map<String, SitemapGenerator> getGenerators(@NotNull Resource sitemapRoot) {
        return Collections.unmodifiableMap(this.consolidateGenerators(sitemapRoot, generator -> generator::getNames));
    }

    @Override
    @NotNull
    public Set<String> getOnDemandNames(@NotNull Resource sitemapRoot) {
        return this.allOnDemand ? this.getNames(sitemapRoot) : Collections.unmodifiableSet(this.consolidateGenerators(sitemapRoot, generator -> generator::getOnDemandNames).keySet());
    }

    private Map<String, SitemapGenerator> consolidateGenerators(Resource sitemapRoot, Function<SitemapGenerator, Function<Resource, Set<String>>> namesProvider) {
        HashMap<String, SitemapGenerator> consolidatedGenerators = new HashMap<String, SitemapGenerator>();
        for (SitemapGenerator generator : this.generators) {
            Set<String> providedNames = namesProvider.apply(generator).apply(sitemapRoot);
            HashSet<String> names = new HashSet<String>(providedNames);
            if (names.removeAll(consolidatedGenerators.keySet()) && LOG.isDebugEnabled()) {
                String alreadyGenerated = String.join((CharSequence)",", consolidatedGenerators.keySet());
                String provided = String.join((CharSequence)",", providedNames);
                LOG.debug("Removed duplicated names. Already generated: '{}', provided by {}: '{}'", new Object[]{alreadyGenerated, generator.getClass().getName(), provided});
            }
            if (names.isEmpty()) {
                LOG.debug("Skipping {} as it did not provide any names for '{}'", (Object)generator.getClass().getName(), (Object)sitemapRoot.getPath());
                continue;
            }
            for (String name : names) {
                consolidatedGenerators.put(name, generator);
            }
        }
        return consolidatedGenerators;
    }

    @ObjectClassDefinition(name="Apache Sling Sitemap - Sitemap Generator Manager")
    static @interface Configuration {
        @AttributeDefinition(name="All on-demand", description="If enabled, forces all registered SitemapGenerators to serve all sitemaps on-demand.")
        public boolean allOnDemand() default false;
    }
}

