/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.scripting.thymeleaf.AbsentMessageRepresentationProvider;
import org.apache.sling.scripting.thymeleaf.internal.ResourceBundleMessageResolverConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.messageresolver.IMessageResolver;

@Component(immediate=true, property={"service.description=ResourceBundle MessageResolver for Sling Scripting Thymeleaf", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=ResourceBundleMessageResolverConfiguration.class)
public class ResourceBundleMessageResolver
implements IMessageResolver {
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="setResourceBundleProvider", unbind="unsetResourceBundleProvider")
    private volatile ResourceBundleProvider resourceBundleProvider;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, bind="setAbsentMessageRepresentationProvider", unbind="unsetAbsentMessageRepresentationProvider")
    private volatile AbsentMessageRepresentationProvider absentMessageRepresentationProvider;
    private Integer order;
    private ResourceBundleMessageResolverConfiguration.AbsentMessageRepresentationType absentMessageRepresentationType;
    public static final Object[] EMPTY_MESSAGE_PARAMETERS = new Object[0];
    private final Logger logger = LoggerFactory.getLogger(ResourceBundleMessageResolver.class);

    public void setResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        this.logger.info("setting resource bundle provider: {}", (Object)resourceBundleProvider);
    }

    public void unsetResourceBundleProvider(ResourceBundleProvider resourceBundleProvider) {
        this.logger.info("unsetting resource bundle provider: {}", (Object)resourceBundleProvider);
    }

    public void setAbsentMessageRepresentationProvider(AbsentMessageRepresentationProvider absentMessageRepresentationProvider) {
        this.logger.info("setting absent message representation provider: {}", (Object)absentMessageRepresentationProvider);
    }

    public void unsetAbsentMessageRepresentationProvider(AbsentMessageRepresentationProvider absentMessageRepresentationProvider) {
        this.logger.info("unsetting absent message representation provider: {}", (Object)absentMessageRepresentationProvider);
    }

    @Activate
    private void activate(ResourceBundleMessageResolverConfiguration configuration) {
        this.logger.debug("activating");
        this.configure(configuration);
    }

    @Modified
    private void modified(ResourceBundleMessageResolverConfiguration configuration) {
        this.logger.debug("modifying");
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
    }

    private void configure(ResourceBundleMessageResolverConfiguration configuration) {
        this.order = configuration.order();
        this.absentMessageRepresentationType = configuration.absentMessageRepresentationType();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Integer getOrder() {
        return this.order;
    }

    public String resolveMessage(ITemplateContext templateContext, Class<?> origin, String key, Object[] messageParameters) {
        this.logger.debug("resolving message for '{}' ({}) with message parameters {}", new Object[]{key, origin, messageParameters});
        if (key == null) {
            return null;
        }
        Locale locale = templateContext.getLocale();
        ResourceBundle resourceBundle = this.resourceBundleProvider.getResourceBundle(locale);
        if (resourceBundle == null) {
            return null;
        }
        String string = resourceBundle.getString(key);
        MessageFormat messageFormat = new MessageFormat(string, locale);
        String message = messageFormat.format(messageParameters != null ? messageParameters : EMPTY_MESSAGE_PARAMETERS);
        this.logger.debug("message: '{}'", (Object)message);
        return message;
    }

    public String createAbsentMessageRepresentation(ITemplateContext templateContext, Class<?> origin, String key, Object[] messageParameters) {
        this.logger.debug("creating absent message representation for '{}' ({}) with message parameters {}", new Object[]{key, origin, messageParameters});
        String message = null;
        AbsentMessageRepresentationProvider absentMessageRepresentationProvider = this.absentMessageRepresentationProvider;
        if (absentMessageRepresentationProvider == null) {
            switch (this.absentMessageRepresentationType) {
                case EMPTY: {
                    message = "";
                    break;
                }
                case BLANK: {
                    message = " ";
                    break;
                }
                case KEY: {
                    message = key;
                }
            }
        } else {
            message = absentMessageRepresentationProvider.provideAbsentMessageRepresentation(templateContext, origin, key, messageParameters);
        }
        this.logger.debug("message: '{}'", (Object)message);
        return message;
    }
}

