/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.User;
import org.owasp.esapi.reference.Log4JLoggerFactory;

public class Log4JLogger
extends org.apache.log4j.Logger
implements Logger {
    private static LoggerFactory factory = new Log4JLoggerFactory();
    private static String applicationName = ESAPI.securityConfiguration().getApplicationName();
    private static boolean logAppName = ESAPI.securityConfiguration().getLogApplicationName();
    private static boolean logServerIP = ESAPI.securityConfiguration().getLogServerIP();

    public Log4JLogger(String name) {
        super(name);
    }

    public static Category getInstance(String name) {
        return LogManager.getLogger((String)name, (LoggerFactory)factory);
    }

    public static Category getInstance(Class clazz) {
        return LogManager.getLogger((String)clazz.getName(), (LoggerFactory)factory);
    }

    public static org.apache.log4j.Logger getLogger(String name) {
        return LogManager.getLogger((String)name, (LoggerFactory)factory);
    }

    public static org.apache.log4j.Logger getLogger(Class clazz) {
        return LogManager.getLogger((String)clazz.getName(), (LoggerFactory)factory);
    }

    @Override
    public void setLevel(int level) {
        try {
            super.setLevel(Log4JLogger.convertESAPILeveltoLoggerLevel(level));
        }
        catch (IllegalArgumentException e) {
            this.error(Logger.SECURITY_FAILURE, "", e);
        }
    }

    @Override
    public int getESAPILevel() {
        Level level = super.getLevel();
        return level == null ? Integer.MAX_VALUE : level.toInt();
    }

    private static Level convertESAPILeveltoLoggerLevel(int level) {
        switch (level) {
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
            case 1000: {
                return Level.FATAL;
            }
            case 800: {
                return Level.ERROR;
            }
            case 600: {
                return Level.WARN;
            }
            case 400: {
                return Level.INFO;
            }
            case 200: {
                return Level.DEBUG;
            }
            case 100: {
                return Level.TRACE;
            }
            case -2147483648: {
                return Level.ALL;
            }
        }
        throw new IllegalArgumentException("Invalid logging level. Value was: " + level);
    }

    @Override
    public void always(Logger.EventType type, String message, Throwable throwable) {
        this.log(Level.OFF, type, message, throwable);
    }

    @Override
    public void always(Logger.EventType type, String message) {
        this.always(type, message, null);
    }

    @Override
    public void trace(Logger.EventType type, String message, Throwable throwable) {
        this.log(Level.TRACE, type, message, throwable);
    }

    @Override
    public void trace(Logger.EventType type, String message) {
        this.log(Level.TRACE, type, message, null);
    }

    @Override
    public void debug(Logger.EventType type, String message, Throwable throwable) {
        this.log(Level.DEBUG, type, message, throwable);
    }

    @Override
    public void debug(Logger.EventType type, String message) {
        this.log(Level.DEBUG, type, message, null);
    }

    @Override
    public void info(Logger.EventType type, String message) {
        this.log(Level.INFO, type, message, null);
    }

    @Override
    public void info(Logger.EventType type, String message, Throwable throwable) {
        this.log(Level.INFO, type, message, throwable);
    }

    @Override
    public void warning(Logger.EventType type, String message, Throwable throwable) {
        this.log(Level.WARN, type, message, throwable);
    }

    @Override
    public void warning(Logger.EventType type, String message) {
        this.log(Level.WARN, type, message, null);
    }

    @Override
    public void error(Logger.EventType type, String message, Throwable throwable) {
        this.log(Level.ERROR, type, message, throwable);
    }

    @Override
    public void error(Logger.EventType type, String message) {
        this.log(Level.ERROR, type, message, null);
    }

    @Override
    public void fatal(Logger.EventType type, String message, Throwable throwable) {
        this.log(Level.FATAL, type, message, throwable);
    }

    @Override
    public void fatal(Logger.EventType type, String message) {
        this.log(Level.FATAL, type, message, null);
    }

    public void always(Object message) {
        this.always(message, null);
    }

    public void always(Object message, Throwable throwable) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.always(Logger.SECURITY_AUDIT, toLog, throwable);
    }

    public void trace(Object message) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.trace(Logger.EVENT_UNSPECIFIED, toLog);
    }

    public void trace(Object message, Throwable throwable) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.trace(Logger.EVENT_UNSPECIFIED, toLog, throwable);
    }

    public void debug(Object message) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.debug(Logger.EVENT_UNSPECIFIED, toLog);
    }

    public void debug(Object message, Throwable throwable) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.debug(Logger.EVENT_UNSPECIFIED, toLog, throwable);
    }

    public void info(Object message) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.info(Logger.EVENT_UNSPECIFIED, toLog);
    }

    public void info(Object message, Throwable throwable) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.info(Logger.EVENT_UNSPECIFIED, toLog, throwable);
    }

    public void warn(Object message) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.warning(Logger.EVENT_UNSPECIFIED, toLog);
    }

    public void warn(Object message, Throwable throwable) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.warning(Logger.EVENT_UNSPECIFIED, toLog, throwable);
    }

    public void error(Object message) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.error(Logger.EVENT_UNSPECIFIED, toLog);
    }

    public void error(Object message, Throwable throwable) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.error(Logger.EVENT_UNSPECIFIED, toLog, throwable);
    }

    public void fatal(Object message) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.fatal(Logger.EVENT_UNSPECIFIED, toLog);
    }

    public void fatal(Object message, Throwable throwable) {
        String toLog = message instanceof String ? (String)message : message.toString();
        this.fatal(Logger.EVENT_UNSPECIFIED, toLog, throwable);
    }

    private void log(Level level, Logger.EventType type, String message, Throwable throwable) {
        if (!this.isEnabledFor((Priority)level)) {
            return;
        }
        if (message == null) {
            message = "";
        }
        String clean = message.replace('\n', '_').replace('\r', '_');
        if (ESAPI.securityConfiguration().getLogEncodingRequired() && !message.equals(clean = ESAPI.encoder().encodeForHTML(message))) {
            clean = clean + " (Encoded)";
        }
        StringBuilder appInfo = new StringBuilder();
        if (ESAPI.currentRequest() != null && logServerIP) {
            appInfo.append(ESAPI.currentRequest().getLocalAddr()).append(":").append(ESAPI.currentRequest().getLocalPort());
        }
        if (logAppName) {
            appInfo.append("/").append(applicationName);
        }
        appInfo.append("/").append(this.getName());
        String typeInfo = "";
        if (type != null) {
            typeInfo = typeInfo + type + " ";
        }
        this.log(Log4JLogger.class.getName(), (Priority)level, "[" + typeInfo + this.getUserInfo() + " -> " + appInfo + "] " + clean, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabledFor((Priority)Level.DEBUG);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabledFor((Priority)Level.FATAL);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabledFor((Priority)Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabledFor((Priority)Level.TRACE);
    }

    @Override
    public boolean isWarningEnabled() {
        return this.isEnabledFor((Priority)Level.WARN);
    }

    public String getUserInfo() {
        HttpSession session;
        String sid = null;
        HttpServletRequest request = ESAPI.httpUtilities().getCurrentRequest();
        if (request != null && (session = request.getSession(false)) != null && (sid = (String)session.getAttribute("ESAPI_SESSION")) == null) {
            sid = "" + ESAPI.randomizer().getRandomInteger(0, 1000000);
            session.setAttribute("ESAPI_SESSION", (Object)sid);
        }
        User user = ESAPI.authenticator().getCurrentUser();
        String userInfo = "";
        if (user != null) {
            userInfo = userInfo + user.getAccountName() + ":" + sid + "@" + user.getLastHostAddress();
        }
        return userInfo;
    }
}

