/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jmx.provider.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.jmx.provider.impl.AttributesResource;
import org.apache.sling.jmx.provider.impl.MapResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeResource
extends AbstractResource {
    private final String path;
    private final ResourceResolver resourceResolver;
    private final ResourceMetadata metadata = new ResourceMetadata();
    private final MBeanAttributeInfo info;
    private final Object attrValue;
    private final AttributesResource parent;
    private volatile Map<String, Object> convertedValue;

    public AttributeResource(ResourceResolver resolver, String path, MBeanAttributeInfo info, Object value, AttributesResource parent) {
        this.resourceResolver = resolver;
        this.path = path;
        this.info = info;
        this.attrValue = value;
        this.parent = parent;
    }

    public Resource getParent() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return "sling:mbeanattribute";
    }

    public String getResourceSuperType() {
        return null;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class || type == Map.class) {
            Map<String, Object> propMap = this.getPropertiesMap();
            return (AdapterType)new DeepReadValueMapDecorator((Resource)this, (ValueMap)new ValueMapDecorator(propMap));
        }
        return (AdapterType)super.adaptTo(type);
    }

    private Map<String, Object> getPropertiesMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sling:resourceType", this.getResourceType());
        if (this.getResourceSuperType() != null) {
            result.put("sling:resourceType", this.getResourceSuperType());
        }
        if (this.info.getDescription() != null) {
            result.put("mbean:description", this.info.getDescription());
        }
        result.put("mbean:type", this.info.getType());
        try {
            Object value = this.attrValue;
            if (value != null) {
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    Object[] values = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        Object o = Array.get(value, i);
                        values[i] = this.convert(o);
                    }
                    result.put("mbean:value", values);
                } else if (!(value instanceof TabularData) && !(value instanceof CompositeData)) {
                    result.put("mbean:value", this.convert(value));
                }
            }
        }
        catch (Exception ignore) {
            result.put("mbean:exception", ignore.getMessage());
        }
        return result;
    }

    private Object convert(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Character) {
            return value;
        }
        return value.toString();
    }

    public Resource getChildResource(String subPath) {
        Map childStructure = this.convertData();
        if (childStructure != null) {
            String[] segments = subPath.split("/");
            Map current = childStructure;
            for (String path : segments) {
                Object child = current.get(path);
                if (child == null) {
                    return null;
                }
                if (!(child instanceof Map)) {
                    return null;
                }
                current = (Map)child;
            }
            return new MapResource(this.getResourceResolver(), this.getPath(), current, this);
        }
        return null;
    }

    private Map<String, Object> convertData() {
        if (this.convertedValue == null) {
            if (this.attrValue instanceof TabularData) {
                this.convertedValue = this.convertObject((TabularData)this.attrValue);
            } else if (this.attrValue instanceof CompositeData) {
                this.convertedValue = this.convertObject((CompositeData)this.attrValue);
            }
        }
        return this.convertedValue;
    }

    private Map<String, Object> convertObject(TabularData td) {
        final TabularType type = td.getTabularType();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sling:resourceType", "sling:mbeanattributes");
        result.put("sling:resourceType", type.getTypeName());
        LinkedHashMap<String, Map<String, Object>> rows = new LinkedHashMap<String, Map<String, Object>>();
        int rowIndex = 1;
        ArrayList values = new ArrayList(td.values());
        Collections.sort(values, new Comparator<CompositeData>(){

            @Override
            public int compare(CompositeData o1, CompositeData o2) {
                for (String name : type.getIndexNames()) {
                    Object value1 = o1.get(name);
                    Object value2 = o2.get(name);
                    int result = value1 instanceof Comparable ? ((Comparable)value1).compareTo(value2) : value1.toString().compareTo(value2.toString());
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        });
        for (CompositeData data : values) {
            rows.put(String.valueOf(rowIndex), this.convertObject(data));
            ++rowIndex;
        }
        result.put("mbean:value", rows);
        return result;
    }

    private Map<String, Object> convertObject(CompositeData cd) {
        CompositeType type = cd.getCompositeType();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sling:resourceType", "sling:mbeanattributes");
        result.put("sling:resourceType", type.getTypeName());
        TreeMap<String, Object> attrMap = new TreeMap<String, Object>();
        attrMap.put("sling:resourceType", "sling:mbeanattributes");
        result.put("mbean:attributes", attrMap);
        Set<String> names = type.keySet();
        for (String name : names) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            attrMap.put(name, dataMap);
            dataMap.put("sling:resourceType", type.getType(name));
            dataMap.put("sling:resourceType", "sling:mbeanattribute");
            if (type.getDescription() != null) {
                dataMap.put("mbean:description", type.getDescription());
            }
            dataMap.put("mbean:type", type.getType(name).getTypeName());
            Object value = cd.get(name);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                Object[] values = new Object[length];
                for (int i = 0; i < length; ++i) {
                    Object o = Array.get(value, i);
                    values[i] = this.convert(o);
                }
                dataMap.put("mbean:value", values);
                continue;
            }
            if (value instanceof TabularData) {
                dataMap.put("mbean:value", this.convertObject((TabularData)value));
                continue;
            }
            if (value instanceof CompositeData) {
                dataMap.put("mbean:value", this.convertObject((CompositeData)value));
                continue;
            }
            dataMap.put("mbean:value", this.convert(value));
        }
        return result;
    }

    public Iterator<Resource> getChildren(final String parentPath, String subPath) {
        Map childStructure = this.convertData();
        if (childStructure != null) {
            Map current = childStructure;
            if (subPath != null) {
                String[] segments;
                for (String path : segments = subPath.split("/")) {
                    Object child = current.get(path);
                    if (child == null) {
                        return null;
                    }
                    if (!(child instanceof Map)) {
                        return null;
                    }
                    current = (Map)child;
                }
            }
            if (current.size() == 0) {
                return null;
            }
            final Iterator<Map.Entry<String, Object>> childIter = current.entrySet().iterator();
            return new Iterator<Resource>(){
                private Map.Entry<String, Object> next = this.seek();

                private Map.Entry<String, Object> seek() {
                    while (childIter.hasNext()) {
                        Map.Entry c = (Map.Entry)childIter.next();
                        if (!(c.getValue() instanceof Map)) continue;
                        return c;
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }

                @Override
                public Resource next() {
                    Map.Entry<String, Object> props = this.next;
                    if (props == null) {
                        throw new NoSuchElementException();
                    }
                    this.next = this.seek();
                    return new MapResource(AttributeResource.this.getResourceResolver(), parentPath + '/' + props.getKey(), (Map)props.getValue(), AttributeResource.this);
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }
            };
        }
        return null;
    }
}

