/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.ScoreNodeMap;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeJoinConditionImpl;
import org.apache.lucene.index.IndexReader;

public class ParentNodeJoin
extends AbstractCondition {
    private final ScoreNodeMap childIndex = new ScoreNodeMap();
    private final IndexReader reader;

    public ParentNodeJoin(MultiColumnQueryHits child, IndexReader reader, HierarchyResolver resolver, ChildNodeJoinConditionImpl condition) throws IOException {
        super(child);
        ScoreNode[] nodes;
        this.reader = reader;
        int idx = ParentNodeJoin.getIndex(child, condition.getChildSelectorQName());
        int[] docNums = new int[1];
        while ((nodes = child.nextScoreNodes()) != null) {
            for (int parentId : docNums = resolver.getParents(nodes[idx].getDoc(reader), docNums)) {
                this.childIndex.addScoreNodes(parentId, nodes);
            }
        }
    }

    @Override
    public ScoreNode[][] getMatchingScoreNodes(ScoreNode parent) throws IOException {
        return this.childIndex.getScoreNodes(parent.getDoc(this.reader));
    }
}

