/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.util;

import java.io.IOException;
import java.io.InputStream;

public class LineInputStream
extends InputStream {
    public static final byte[] LS_UNIX = new byte[]{10};
    public static final byte[] LS_WINDOWS = new byte[]{13, 10};
    public static final byte[] LS_NATIVE = System.getProperty("line.separator").getBytes();
    private byte[] buffer = new byte[8192];
    private byte[] lineFeed = LS_NATIVE;
    private byte[] lineSpool;
    private int pos = 0;
    private int end = 0;
    private static final char STATE_INIT = ' ';
    private static final char STATE_CR = 'c';
    private static final char STATE_LF = 'l';
    private static final char STATE_CRLF = 'f';
    private char state = (char)32;
    boolean isEof = false;
    private byte[] spool;
    private int spoolPos = 0;
    private final InputStream in;

    public LineInputStream(InputStream in, byte[] ls) {
        this.in = in;
        if (ls != null) {
            this.lineFeed = ls;
        }
        this.lineSpool = new byte[this.lineFeed.length + 1];
        System.arraycopy(this.lineFeed, 0, this.lineSpool, 0, this.lineFeed.length);
    }

    private int fillBuffer() throws IOException {
        int ret = this.in.read(this.buffer, this.end, this.buffer.length - this.end);
        if (ret >= 0) {
            this.end += ret;
        } else {
            this.isEof = true;
        }
        return ret;
    }

    @Override
    public int read() throws IOException {
        byte[] one = new byte[1];
        if (this.read(one) == -1) {
            return -1;
        }
        return one[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isEof && this.spool == null) {
            if (this.state != ' ') {
                this.spool = this.lineFeed;
                this.state = (char)32;
            } else {
                return -1;
            }
        }
        int total = 0;
        while (total < len) {
            byte c;
            if (this.spool != null) {
                b[off + total++] = this.spool[this.spoolPos++];
                if (this.spoolPos != this.spool.length) continue;
                this.spool = null;
                this.spoolPos = 0;
                continue;
            }
            if (this.pos == this.end) {
                int ret = this.fillBuffer();
                if (ret == 0 && this.pos == this.end) {
                    this.end = 0;
                    this.pos = 0;
                    continue;
                }
                if (ret == -1) break;
            }
            if ((c = this.buffer[this.pos++]) == 10) {
                switch (this.state) {
                    case ' ': {
                        this.state = (char)108;
                        break;
                    }
                    case 'c': {
                        this.state = (char)102;
                        break;
                    }
                    case 'l': {
                        this.spool = this.lineFeed;
                        break;
                    }
                    case 'f': {
                        this.spool = this.lineFeed;
                        this.state = (char)108;
                    }
                }
                continue;
            }
            if (c == 13) {
                switch (this.state) {
                    case ' ': {
                        this.state = (char)99;
                        break;
                    }
                    case 'l': {
                        this.state = (char)102;
                        break;
                    }
                    case 'c': {
                        this.spool = this.lineFeed;
                        break;
                    }
                    case 'f': {
                        this.spool = this.lineFeed;
                        this.state = (char)99;
                    }
                }
                continue;
            }
            if (this.state != ' ') {
                this.spool = this.lineSpool;
                this.lineSpool[this.lineSpool.length - 1] = c;
                this.state = (char)32;
                continue;
            }
            b[off + total++] = c;
        }
        return total;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

