/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.util;

import java.util.Comparator;
import javax.xml.namespace.QName;
import relocated_for_contentpackage.javax.jcr.Item;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.Name;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NameException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NameParser;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.util.QNameComparator;

public class ItemNameComparator2
implements Comparator<Item> {
    private final NamespaceResolver nsResolver;

    public ItemNameComparator2(NamespaceResolver nsResolver) {
        this.nsResolver = nsResolver;
    }

    private QName getQName(String rawName) throws RepositoryException {
        try {
            Name name = NameParser.parse(rawName, this.nsResolver, NameFactoryImpl.getInstance());
            return new QName(name.getNamespaceURI(), name.getLocalName(), this.nsResolver.getPrefix(name.getNamespaceURI()));
        }
        catch (NameException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            throw new RepositoryException(msg, e);
        }
    }

    @Override
    public int compare(Item o1, Item o2) {
        try {
            return QNameComparator.INSTANCE.compare(this.getQName(o1.getName()), this.getQName(o2.getName()));
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }
}

