/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions;

import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.HandlerContext;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.extension.apiregions.api.artifacts.ArtifactRules;

public class ArtifactRulesMergeHandler
implements MergeHandler {
    public boolean canMerge(Extension extension) {
        return "artifact-rules".equals(extension.getName());
    }

    public void merge(HandlerContext context, Feature targetFeature, Feature sourceFeature, Extension targetExtension, Extension sourceExtension) {
        if (targetExtension == null) {
            ArtifactRules sourceRules = ArtifactRules.getArtifactRules(sourceExtension);
            ArtifactRules.setArtifactRules(targetFeature, sourceRules);
        } else {
            ArtifactRules sourceRules = ArtifactRules.getArtifactRules(sourceExtension);
            ArtifactRules targetRules = ArtifactRules.getArtifactRules(targetExtension);
            if (context.isInitialMerge()) {
                targetRules.setMode(sourceRules.getMode());
            } else if (targetRules.getMode().ordinal() > sourceRules.getMode().ordinal()) {
                targetRules.setMode(sourceRules.getMode());
            }
            targetRules.getBundleVersionRules().addAll(sourceRules.getBundleVersionRules());
            ArtifactRules.setArtifactRules(targetFeature, targetRules);
        }
    }
}

