/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Objects;
import java.util.function.Function;
import org.apache.felix.cm.json.io.Configurations;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.sling.feature.cpconverter.handlers.AbstractConfigurationEntryHandler;
import org.apache.sling.feature.cpconverter.shared.AbstractJcrNodeParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public final class XmlConfigurationEntryHandler
extends AbstractConfigurationEntryHandler {
    public XmlConfigurationEntryHandler() {
        super("xml");
    }

    @Override
    @Nullable
    protected Dictionary<String, Object> parseConfiguration(@NotNull String name, @NotNull InputStream input) {
        try {
            return (Dictionary)new JcrConfigurationParser().parse(input);
        }
        catch (Exception e) {
            this.logger.warn("Current OSGi configuration does not represent a valid XML document, see nested exceptions", (Throwable)e);
            return null;
        }
    }

    private static final class JcrConfigurationParser
    extends AbstractJcrNodeParser<Dictionary<String, Object>> {
        private static final String SLING_OSGICONFIG = "sling:OsgiConfig";
        private Dictionary<String, Object> configuration;

        public JcrConfigurationParser() {
            super(SLING_OSGICONFIG);
        }

        @Override
        protected void onJcrRootElement(String uri, String localName, String qName, Attributes attributes) {
            this.configuration = Configurations.newConfiguration();
            for (int i = 0; i < attributes.getLength(); ++i) {
                DocViewProperty property;
                Object[] values;
                String attributeValue;
                String attributeQName = attributes.getQName(i);
                if (attributeQName.indexOf(58) != -1 || !JcrConfigurationParser.isValid(attributeValue = attributes.getValue(i)) || (values = JcrConfigurationParser.getValues(property = DocViewProperty.parse((String)attributeQName, (String)attributeValue))).length == 0) continue;
                if (!property.isMulti) {
                    this.configuration.put(attributeQName, values[0]);
                    continue;
                }
                this.configuration.put(attributeQName, values);
            }
        }

        private static boolean isValid(@Nullable String s) {
            return s != null && !s.isEmpty();
        }

        @NotNull
        private static Object[] getValues(@NotNull DocViewProperty property) {
            Object[] values;
            switch (property.type) {
                case 5: {
                    values = JcrConfigurationParser.mapValues(property.values, s -> {
                        Calendar cal = ISO8601.parse((String)s);
                        return cal != null ? Long.valueOf(cal.getTimeInMillis()) : null;
                    });
                    break;
                }
                case 4: {
                    values = JcrConfigurationParser.mapValues(property.values, Double::parseDouble);
                    break;
                }
                case 3: {
                    values = JcrConfigurationParser.mapValues(property.values, Long::parseLong);
                    break;
                }
                case 6: {
                    values = JcrConfigurationParser.mapValues(property.values, Boolean::valueOf);
                    break;
                }
                default: {
                    values = property.values;
                }
            }
            return values;
        }

        @NotNull
        private static Object[] mapValues(@NotNull String[] strValues, Function<String, Object> function) {
            return Arrays.stream(strValues).filter(JcrConfigurationParser::isValid).map(function).filter(Objects::nonNull).toArray();
        }

        @Override
        @NotNull
        protected Dictionary<String, Object> getParsingResult() {
            return this.configuration;
        }
    }
}

