/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.helper;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.sling.engine.impl.Config;
import org.apache.sling.engine.impl.ProductInfoProvider;
import org.apache.sling.engine.impl.helper.ExternalServletContextWrapper;
import org.apache.sling.engine.impl.request.SlingRequestDispatcher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.servlet.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.servlet.whiteboard.propertytypes.HttpWhiteboardListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ServletContextListener.class}, configurationPid={"org.apache.sling.engine.impl.SlingMainServlet"})
@HttpWhiteboardContextSelect(value="(&(osgi.http.whiteboard.context.name=org.apache.sling)(objectClass=org.osgi.service.servlet.context.ServletContextHelper))")
@HttpWhiteboardListener
public class SlingServletContext
implements ServletContext,
ServletContextListener {
    public static final String TARGET = "(name=org.apache.sling)";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ProductInfoProvider productInfoProvider;
    private final BundleContext bundleContext;
    private volatile String serverInfo;
    private volatile String configuredServerInfo;
    private volatile long initCounter;
    private volatile ServletContext servletContext;
    private volatile ServiceRegistration<ServletContext> registration;
    private final boolean protectHeadersOnInclude;
    private final boolean checkContentTypeOnInclude;

    @Activate
    public SlingServletContext(Config config, BundleContext bundleContext, @Reference ProductInfoProvider infoProvider) {
        this.bundleContext = bundleContext;
        this.productInfoProvider = infoProvider;
        this.protectHeadersOnInclude = config.sling_includes_protectheaders();
        this.checkContentTypeOnInclude = config.sling_includes_checkcontenttype();
        this.setup(config);
    }

    @Modified
    protected void modified(Config config) {
        this.setup(config);
    }

    private void setup(Config config) {
        this.configuredServerInfo = config.sling_serverinfo() != null && !config.sling_serverinfo().isEmpty() ? config.sling_serverinfo() : null;
        this.setServerInfo();
    }

    private void setServerInfo() {
        if (this.configuredServerInfo != null) {
            this.serverInfo = this.configuredServerInfo;
        } else {
            String containerProductInfo;
            if (this.getServletContext() == null) {
                containerProductInfo = "unregistered";
            } else {
                String containerInfo = this.getServletContext().getServerInfo();
                if (containerInfo != null && containerInfo.length() > 0) {
                    int lbrace = containerInfo.indexOf(40);
                    if (lbrace < 0) {
                        lbrace = containerInfo.length();
                    }
                    containerProductInfo = containerInfo.substring(0, lbrace).trim();
                } else {
                    containerProductInfo = "unknown";
                }
            }
            this.serverInfo = String.format("%s (%s, %s %s, %s %s %s)", this.productInfoProvider.getProductInfo(), containerProductInfo, System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        }
    }

    private void runAsync(Runnable r, String action) {
        Thread thread = new Thread(r, this.getClass().getSimpleName() + "-" + action);
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((t, exception) -> {
            String msg = String.format("Exception while async %s", action);
            this.log.error(msg, exception);
        });
        thread.start();
    }

    private ServiceRegistration<ServletContext> registerServletContext() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("name", "org.apache.sling");
        return this.bundleContext.registerService(ServletContext.class, (Object)this, props);
    }

    private void unregisterServletContext(ServiceRegistration<ServletContext> reg) {
        try {
            reg.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        long counter;
        ServletContext delegatee;
        SlingServletContext slingServletContext = this;
        synchronized (slingServletContext) {
            this.servletContext = sce.getServletContext();
            this.setServerInfo();
            delegatee = this.servletContext;
            ++this.initCounter;
            counter = this.initCounter;
        }
        if (delegatee != null) {
            this.runAsync(this.registerContext(delegatee, counter), "registration");
        }
    }

    Runnable registerContext(ServletContext delegatee, long counter) {
        return () -> {
            boolean register;
            SlingServletContext slingServletContext = this;
            synchronized (slingServletContext) {
                register = this.servletContext == delegatee;
            }
            if (register) {
                ServiceRegistration<ServletContext> reg = this.registerServletContext();
                boolean immediatelyUnregister = false;
                SlingServletContext slingServletContext2 = this;
                synchronized (slingServletContext2) {
                    if (this.initCounter == counter) {
                        this.registration = reg;
                    } else {
                        immediatelyUnregister = true;
                    }
                }
                if (immediatelyUnregister) {
                    this.unregisterServletContext(reg);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        ServiceRegistration<ServletContext> reg;
        SlingServletContext slingServletContext = this;
        synchronized (slingServletContext) {
            ++this.initCounter;
            reg = this.registration;
            this.registration = null;
            this.servletContext = null;
            this.setServerInfo();
        }
        if (reg != null) {
            this.runAsync(() -> this.unregisterServletContext(reg), "unregistration");
        }
    }

    public String getServletContextName() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getServletContextName();
        }
        return null;
    }

    public String getContextPath() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getContextPath();
        }
        return null;
    }

    public String getInitParameter(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getInitParameter(name);
        }
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getInitParameterNames();
        }
        return null;
    }

    public Object getAttribute(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getAttribute(name);
        }
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getAttributeNames();
        }
        return Collections.enumeration(Collections.emptyList());
    }

    public void removeAttribute(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            delegatee.removeAttribute(name);
        }
    }

    public void setAttribute(String name, Object object) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            delegatee.setAttribute(name, object);
        }
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public int getMajorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getMajorVersion();
        }
        return 3;
    }

    public int getMinorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getMinorVersion();
        }
        return 0;
    }

    public String getMimeType(String file) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getMimeType(file);
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            this.log.error("getRequestDispatcher: No path, cannot create request dispatcher");
            return null;
        }
        return new SlingRequestDispatcher(path, null, this.protectHeadersOnInclude, this.checkContentTypeOnInclude);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getNamedDispatcher(name);
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getResource(path);
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getResourceAsStream(path);
        }
        return null;
    }

    public Set<String> getResourcePaths(String parentPath) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getResourcePaths(parentPath);
        }
        return null;
    }

    public String getRealPath(String path) {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getRealPath(path);
        }
        return null;
    }

    public void log(String message, Throwable throwable) {
        this.log.error(message, throwable);
    }

    public void log(String message) {
        this.log.info(message);
    }

    public ServletContext getContext(String uripath) {
        ServletContext otherContext;
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null && (otherContext = delegatee.getContext(uripath)) != null && otherContext != delegatee) {
            return this.wrapServletContext(otherContext);
        }
        return null;
    }

    public int getEffectiveMajorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getEffectiveMajorVersion();
        }
        return 3;
    }

    public int getEffectiveMinorVersion() {
        ServletContext delegatee = this.getServletContext();
        if (delegatee != null) {
            return delegatee.getEffectiveMinorVersion();
        }
        return 0;
    }

    public boolean setInitParameter(String name, String value) {
        throw new IllegalStateException();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.getServletContext().getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new IllegalStateException();
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.getServletContext().getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.getServletContext().getEffectiveSessionTrackingModes();
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.getServletContext().getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        throw new SecurityException();
    }

    public void declareRoles(String ... roleNames) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new IllegalStateException();
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new IllegalStateException();
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) {
        throw new IllegalStateException();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        throw new IllegalStateException();
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new IllegalStateException();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new IllegalStateException();
    }

    public <T extends Filter> T createFilter(Class<T> clazz) {
        throw new IllegalStateException();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        throw new IllegalStateException();
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw new IllegalStateException();
    }

    public void addListener(String className) {
        throw new IllegalStateException();
    }

    public <T extends EventListener> void addListener(T t) {
        throw new IllegalStateException();
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new IllegalStateException();
    }

    public <T extends EventListener> T createListener(Class<T> clazz) {
        throw new IllegalStateException();
    }

    public String getVirtualServerName() {
        return this.getServletContext().getVirtualServerName();
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new IllegalStateException();
    }

    public String getRequestCharacterEncoding() {
        return this.getServletContext().getRequestCharacterEncoding();
    }

    public String getResponseCharacterEncoding() {
        return this.getServletContext().getResponseCharacterEncoding();
    }

    public int getSessionTimeout() {
        return this.getServletContext().getSessionTimeout();
    }

    public void setRequestCharacterEncoding(String encoding) {
        throw new IllegalStateException();
    }

    public void setResponseCharacterEncoding(String encoding) {
        throw new IllegalStateException();
    }

    public void setSessionTimeout(int sessionTimeout) {
        throw new IllegalStateException();
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    protected ServletContext wrapServletContext(ServletContext context) {
        return new ExternalServletContextWrapper(context);
    }
}

