/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class SimpleDistributionRequest
implements DistributionRequest {
    private final DistributionRequestType requestType;
    private final Set<String> deepPaths;
    private final Map<String, String[]> pathFilters;
    private final String[] paths;

    public SimpleDistributionRequest(DistributionRequestType requestType, boolean isDeep, String ... paths) {
        this(requestType, paths, (Set<String>)(isDeep ? new HashSet<String>(Arrays.asList(paths)) : new HashSet()));
    }

    public SimpleDistributionRequest(DistributionRequestType requestType, String ... paths) {
        this(requestType, false, paths);
    }

    public SimpleDistributionRequest(DistributionRequestType requestType, String[] paths, Set<String> deepPaths) {
        this(requestType, paths, deepPaths, new HashMap<String, String[]>());
    }

    public SimpleDistributionRequest(DistributionRequestType requestType, String[] paths, Set<String> deepPaths, Map<String, String[]> pathFilters) {
        this.requestType = requestType;
        this.paths = this.sanitise(paths);
        this.deepPaths = this.sanitise(deepPaths);
        this.pathFilters = pathFilters;
    }

    @Override
    @Nonnull
    public DistributionRequestType getRequestType() {
        return this.requestType;
    }

    @Override
    public String[] getPaths() {
        return this.paths;
    }

    @Override
    public boolean isDeep(String path) {
        return this.deepPaths.contains(path);
    }

    @Override
    @Nonnull
    public String[] getFilters(String path) {
        String[] filters = this.pathFilters.get(path);
        return filters != null ? filters : new String[]{};
    }

    public String toString() {
        return "SimpleDistributionRequest{requestType=" + (Object)((Object)this.requestType) + ", paths=" + Arrays.toString(this.paths) + '}';
    }

    private String[] sanitise(String[] paths) {
        if (paths == null) {
            return new String[0];
        }
        List<String> pathsOut = Arrays.asList(paths).stream().filter(this::notEmpty).collect(Collectors.toList());
        return pathsOut.toArray(new String[0]);
    }

    private Set<String> sanitise(Set<String> paths) {
        if (paths == null) {
            return new HashSet<String>();
        }
        return paths.stream().filter(this::notEmpty).collect(Collectors.toSet());
    }

    private boolean notEmpty(String path) {
        return path != null && !path.trim().isEmpty();
    }
}

