/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.core.commands;

import org.apache.sling.crankstart.api.CrankstartCommand;
import org.apache.sling.crankstart.api.CrankstartCommandLine;
import org.apache.sling.crankstart.api.CrankstartContext;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartBundles
implements CrankstartCommand {
    public static final String I_START_ALL_BUNDLES = "start.all.bundles";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean appliesTo(CrankstartCommandLine commandLine) {
        return I_START_ALL_BUNDLES.equals(commandLine.getVerb());
    }

    public String getDescription() {
        return "start.all.bundles: start all currently loaded bundles";
    }

    public void execute(CrankstartContext crankstartContext, CrankstartCommandLine commandLine) throws Exception {
        int count = 0;
        int failures = 0;
        for (Bundle bundle : crankstartContext.getOsgiFramework().getBundleContext().getBundles()) {
            if (this.isFragment(bundle)) {
                this.log.debug("Ignoring fragment bundle {}", (Object)bundle.getSymbolicName());
                continue;
            }
            if (bundle.getState() != 32) {
                this.log.info("Starting bundle {}", (Object)bundle.getSymbolicName());
                try {
                    bundle.start();
                    ++count;
                }
                catch (Exception e) {
                    this.log.warn("Failed to start bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
                    ++failures;
                }
                continue;
            }
            this.log.debug("Bundle {} is already active", (Object)bundle.getSymbolicName());
        }
        this.log.info("{} bundles started, {} failures", (Object)count, (Object)failures);
    }

    private boolean isFragment(Bundle b) {
        return b.getHeaders().get("Fragment-Host") != null;
    }
}

