/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl.actions;

import java.util.Calendar;
import java.util.Collections;
import java.util.UUID;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.cms.reference.forms.FormAction;
import org.apache.sling.cms.reference.forms.FormActionResult;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FormAction.class})
public class RequestPasswordResetAction
implements FormAction {
    public static final String RESOURCE_TYPE = "reference/components/forms/actions/requestpasswordreset";
    public static final String PN_RESETTOKEN = "resettoken";
    public static final String PN_RESETTIMEOUT = "resettimeout";
    private static final Logger log = LoggerFactory.getLogger(RequestPasswordResetAction.class);
    private ResourceResolverFactory factory;

    @Activate
    public RequestPasswordResetAction(@Reference ResourceResolverFactory factory) {
        this.factory = factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FormActionResult handleForm(Resource actionResource, FormRequest request) throws FormException {
        String email = (String)request.getFormData().get("email", String.class);
        int resetTimeout = (Integer)actionResource.getValueMap().get(PN_RESETTIMEOUT, Integer.class);
        try (ResourceResolver adminResolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "slingcms-reference-usermanager"));){
            JackrabbitSession session = (JackrabbitSession)adminResolver.adaptTo(Session.class);
            UserManager userManager = session.getUserManager();
            if (userManager.getAuthorizable(email) != null) {
                User user = (User)userManager.getAuthorizable(email);
                String resetToken = UUID.randomUUID().toString();
                Calendar deadline = Calendar.getInstance();
                deadline.add(13, resetTimeout);
                ValueFactory vf = session.getValueFactory();
                user.setProperty(PN_RESETTOKEN, vf.createValue(resetToken));
                user.setProperty(PN_RESETTIMEOUT, vf.createValue(deadline));
                request.getFormData().put((Object)PN_RESETTOKEN, (Object)resetToken);
                adminResolver.commit();
                return FormActionResult.success("Reset token created");
            }
            log.warn("Unable to find user {}", (Object)email);
            FormActionResult formActionResult = FormActionResult.failure("Unable to find user");
            return formActionResult;
        }
        catch (Exception e) {
            throw new FormException("Failed to initiate password reset", e);
        }
    }

    @Override
    public boolean handles(Resource actionResource) {
        return RESOURCE_TYPE.equals(actionResource.getResourceType());
    }
}

