/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.publication;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.cms.PublishableResource;
import org.apache.sling.cms.publication.PublicationType;
import org.osgi.service.event.Event;

public class PublicationEvent
extends Event {
    public static final String EVENT_PUBLISH = "org/apache/sling/cms/publication/PUBLISH";
    public static final String EVENT_UNPUBLISH = "org/apache/sling/cms/publication/UNPUBLISH";
    public static final String PN_PUBLICATION_TYPE = "publicationType";
    public static final String PN_DEEP = "isDeep";

    private PublicationEvent(String topic, Map<String, ?> properties) {
        super(topic, properties);
    }

    public static PublicationEvent publish(PublishableResource resource, boolean deep) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("path", resource.getPath());
        properties.put(PN_PUBLICATION_TYPE, PublicationType.ADD.toString());
        properties.put(PN_DEEP, deep);
        return new PublicationEvent(EVENT_PUBLISH, properties);
    }

    public static PublicationEvent unpublish(PublishableResource resource, boolean deep) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("path", resource.getPath());
        properties.put(PN_PUBLICATION_TYPE, PublicationType.DELETE.toString());
        properties.put(PN_DEEP, deep);
        return new PublicationEvent(EVENT_UNPUBLISH, properties);
    }
}

