/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.util.ArrayList;
import org.apache.sling.commons.osgi.ManifestHeader;

class PathMapping {
    public static final String DIR_PATH = "path";
    public static final String DIR_JSON = "propsJSON";
    private static final char prefixSeparatorChar = '!';
    private final String resourceRoot;
    private final String resourceRootPrefix;
    private final String entryRoot;
    private final String entryRootPrefix;
    private final String jsonExpandExtension;

    public static PathMapping[] getRoots(String rootList) {
        ArrayList<PathMapping> prefixList = new ArrayList<PathMapping>();
        ManifestHeader header = ManifestHeader.parse((String)rootList);
        for (ManifestHeader.Entry entry : header.getEntries()) {
            String resourceRoot = entry.getValue();
            String pathDirective = entry.getDirectiveValue(DIR_PATH);
            String expandDirective = entry.getDirectiveValue(DIR_JSON);
            if (pathDirective != null) {
                prefixList.add(new PathMapping(resourceRoot, pathDirective, expandDirective));
                continue;
            }
            prefixList.add(PathMapping.create(resourceRoot, expandDirective));
        }
        return prefixList.toArray(new PathMapping[prefixList.size()]);
    }

    static PathMapping create(String configPath, String expandDirective) {
        String resourceRoot;
        String entryRoot;
        int prefixSep = configPath.indexOf(33);
        if (prefixSep >= 0) {
            entryRoot = configPath.substring(prefixSep + 1);
            resourceRoot = configPath.substring(0, prefixSep).concat(entryRoot);
        } else {
            resourceRoot = configPath;
            entryRoot = null;
        }
        return new PathMapping(resourceRoot, entryRoot, expandDirective);
    }

    PathMapping(String resourceRoot, String entryRoot, String expandDirective) {
        this.resourceRoot = PathMapping.ensureNoTrailingSlash(resourceRoot);
        this.resourceRootPrefix = PathMapping.ensureTrailingSlash(resourceRoot);
        this.entryRoot = PathMapping.ensureLeadingSlash(PathMapping.ensureNoTrailingSlash(entryRoot));
        this.entryRootPrefix = PathMapping.ensureLeadingSlash(PathMapping.ensureTrailingSlash(entryRoot));
        this.jsonExpandExtension = PathMapping.ensureLeadingDot(expandDirective);
    }

    String getJSONPropertiesExtension() {
        return this.jsonExpandExtension;
    }

    boolean isChild(String resourcePath) {
        return resourcePath.startsWith(this.resourceRootPrefix) || resourcePath.equals(this.resourceRoot);
    }

    String getEntryPath(String resourcePath) {
        if (this.entryRootPrefix == null) {
            return resourcePath;
        }
        if (resourcePath.startsWith(this.resourceRootPrefix)) {
            return this.entryRootPrefix.concat(resourcePath.substring(this.resourceRootPrefix.length()));
        }
        if (resourcePath.equals(this.resourceRoot)) {
            return this.entryRoot;
        }
        return null;
    }

    String getResourcePath(String entryPath) {
        if (this.entryRootPrefix == null) {
            return entryPath;
        }
        if (entryPath.startsWith(this.entryRootPrefix)) {
            return this.resourceRootPrefix.concat(entryPath.substring(this.entryRootPrefix.length()));
        }
        if (entryPath.equals(this.entryRoot)) {
            return this.resourceRoot;
        }
        return null;
    }

    String getResourceRoot() {
        return this.resourceRoot;
    }

    String getResourceRootPrefix() {
        return this.resourceRootPrefix;
    }

    String getEntryRoot() {
        return this.entryRoot;
    }

    String getEntryRootPrefix() {
        return this.entryRootPrefix;
    }

    private static String ensureLeadingDot(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        if (!path.startsWith(".")) {
            return ".".concat(path);
        }
        return path;
    }

    private static String ensureNoTrailingSlash(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.endsWith("/")) {
            return PathMapping.ensureNoTrailingSlash(path.substring(0, path.length() - 1));
        }
        return path;
    }

    private static String ensureTrailingSlash(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        if (!path.endsWith("/")) {
            return path.concat("/");
        }
        return path;
    }

    private static String ensureLeadingSlash(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        if (!path.startsWith("/")) {
            return "/".concat(path);
        }
        return path;
    }

    public String toString() {
        return "MappedPath: " + this.getResourceRoot() + " -> " + this.getEntryRoot();
    }
}

