/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.httpasyncclient.v4.wrapper;

import org.apache.http.concurrent.FutureCallback;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.plugin.httpasyncclient.v4.Constants;

public class FutureCallbackWrapper<T>
implements FutureCallback<T> {
    private FutureCallback<T> callback;

    public FutureCallbackWrapper(FutureCallback<T> callback) {
        this.callback = callback;
    }

    public void completed(T o) {
        if (ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        if (this.callback != null) {
            this.callback.completed(o);
        }
    }

    public void failed(Exception e) {
        Constants.HTTP_CONTEXT_LOCAL.remove();
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log((Throwable)e);
            ContextManager.stopSpan();
        }
        if (this.callback != null) {
            this.callback.failed(e);
        }
    }

    public void cancelled() {
        Constants.HTTP_CONTEXT_LOCAL.remove();
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().errorOccurred();
            ContextManager.stopSpan();
        }
        if (this.callback != null) {
            this.callback.cancelled();
        }
    }
}

