/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.network.trace.component.command;

import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.network.common.v3.Command;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.trace.component.command.BaseCommand;
import org.apache.skywalking.apm.network.trace.component.command.Deserializable;
import org.apache.skywalking.apm.network.trace.component.command.Serializable;

public class AsyncProfilerTaskCommand
extends BaseCommand
implements Serializable,
Deserializable<AsyncProfilerTaskCommand> {
    public static final Deserializable<AsyncProfilerTaskCommand> DESERIALIZER = new AsyncProfilerTaskCommand("", "", 0, null, "", 0L);
    public static final String NAME = "AsyncProfilerTaskQuery";
    private final String taskId;
    private final int duration;
    private final String execArgs;
    private final long createTime;

    public AsyncProfilerTaskCommand(String serialNumber, String taskId, int duration, List<String> events, String execArgs, long createTime) {
        super(NAME, serialNumber);
        this.taskId = taskId;
        this.duration = duration;
        this.createTime = createTime;
        String comma = ",";
        StringBuilder sb = new StringBuilder();
        if (Objects.nonNull(events) && !events.isEmpty()) {
            sb.append("event=").append(String.join((CharSequence)comma, events)).append(comma);
        }
        if (execArgs != null && !execArgs.isEmpty()) {
            sb.append(execArgs);
        }
        this.execArgs = sb.toString();
    }

    public AsyncProfilerTaskCommand(String serialNumber, String taskId, int duration, String execArgs, long createTime) {
        super(NAME, serialNumber);
        this.taskId = taskId;
        this.duration = duration;
        this.execArgs = execArgs;
        this.createTime = createTime;
    }

    @Override
    public AsyncProfilerTaskCommand deserialize(Command command) {
        List<KeyStringValuePair> argsList = command.getArgsList();
        String taskId = null;
        int duration = 0;
        String execArgs = null;
        long createTime = 0L;
        String serialNumber = null;
        for (KeyStringValuePair pair : argsList) {
            if ("SerialNumber".equals(pair.getKey())) {
                serialNumber = pair.getValue();
                continue;
            }
            if ("TaskId".equals(pair.getKey())) {
                taskId = pair.getValue();
                continue;
            }
            if ("Duration".equals(pair.getKey())) {
                duration = Integer.parseInt(pair.getValue());
                continue;
            }
            if ("ExecArgs".equals(pair.getKey())) {
                execArgs = pair.getValue();
                continue;
            }
            if (!"CreateTime".equals(pair.getKey())) continue;
            createTime = Long.parseLong(pair.getValue());
        }
        return new AsyncProfilerTaskCommand(serialNumber, taskId, duration, execArgs, createTime);
    }

    @Override
    public Command.Builder serialize() {
        Command.Builder builder = this.commandBuilder();
        builder.addArgs(KeyStringValuePair.newBuilder().setKey("TaskId").setValue(this.taskId)).addArgs(KeyStringValuePair.newBuilder().setKey("Duration").setValue(String.valueOf(this.duration))).addArgs(KeyStringValuePair.newBuilder().setKey("ExecArgs").setValue(this.execArgs)).addArgs(KeyStringValuePair.newBuilder().setKey("CreateTime").setValue(String.valueOf(this.createTime)));
        return builder;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getExecArgs() {
        return this.execArgs;
    }

    public long getCreateTime() {
        return this.createTime;
    }
}

