/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc.protocol;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@UnstableApi
public final class DeframedMessage
implements SafeCloseable {
    private final int type;
    @Nullable
    private final ByteBuf buf;
    @Nullable
    private final InputStream stream;
    private boolean closed;

    @VisibleForTesting
    public DeframedMessage(ByteBuf buf, int type) {
        this(Objects.requireNonNull(buf, "buf"), null, type);
    }

    @VisibleForTesting
    public DeframedMessage(InputStream stream, int type) {
        this(null, Objects.requireNonNull(stream, "stream"), type);
    }

    private DeframedMessage(@Nullable ByteBuf buf, @Nullable InputStream stream, int type) {
        this.buf = buf;
        this.stream = stream;
        this.type = type;
    }

    @Nullable
    public ByteBuf buf() {
        return this.buf;
    }

    @Nullable
    public InputStream stream() {
        return this.stream;
    }

    public boolean isTrailer() {
        return this.type >> 7 == 1;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeframedMessage)) {
            return false;
        }
        DeframedMessage that = (DeframedMessage)o;
        return this.type == that.type && Objects.equals(this.buf, that.buf) && Objects.equals(this.stream, that.stream);
    }

    public int hashCode() {
        return Objects.hash(this.buf, this.stream);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.buf != null) {
            this.buf.release();
        } else {
            assert (this.stream != null);
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

