/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.grpc;

import io.grpc.Channel;
import io.grpc.netty.NettyChannelBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.FetchingConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.apache.skywalking.oap.server.configuration.grpc.RemoteEndpointSettings;
import org.apache.skywalking.oap.server.configuration.service.ConfigurationRequest;
import org.apache.skywalking.oap.server.configuration.service.ConfigurationResponse;
import org.apache.skywalking.oap.server.configuration.service.ConfigurationServiceGrpc;
import org.apache.skywalking.oap.server.configuration.service.GroupConfigurationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCConfigWatcherRegister
extends FetchingConfigWatcherRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCConfigWatcherRegister.class);
    private RemoteEndpointSettings settings;
    private ConfigurationServiceGrpc.ConfigurationServiceBlockingStub stub;
    private String uuid = null;
    private String groupUuid = null;

    public GRPCConfigWatcherRegister(RemoteEndpointSettings settings) {
        super((long)settings.getPeriod());
        this.settings = settings;
        this.stub = ConfigurationServiceGrpc.newBlockingStub((Channel)NettyChannelBuilder.forAddress((String)settings.getHost(), (int)settings.getPort()).usePlaintext().maxInboundMessageSize(settings.getMaxInboundMessageSize()).build());
    }

    public Optional<ConfigTable> readConfig(Set<String> keys) {
        ConfigTable table = new ConfigTable();
        try {
            ConfigurationResponse response;
            String responseUuid;
            ConfigurationRequest.Builder builder = ConfigurationRequest.newBuilder().setClusterName(this.settings.getClusterName());
            if (this.uuid != null) {
                builder.setUuid(this.uuid);
            }
            if (Objects.equals(this.uuid, responseUuid = (response = this.stub.call(builder.build())).getUuid())) {
                return Optional.empty();
            }
            response.getConfigTableList().forEach(config -> {
                String name = config.getName();
                if (keys.contains(name)) {
                    table.add(new ConfigTable.ConfigItem(name, config.getValue()));
                }
            });
            this.uuid = responseUuid;
        }
        catch (Exception e) {
            log.error("Remote config center [{}] is not available.", (Object)this.settings, (Object)e);
        }
        return Optional.of(table);
    }

    public Optional<GroupConfigTable> readGroupConfig(Set<String> keys) {
        GroupConfigTable groupConfigTable = new GroupConfigTable();
        try {
            GroupConfigurationResponse response;
            String responseUuid;
            ConfigurationRequest.Builder builder = ConfigurationRequest.newBuilder().setClusterName(this.settings.getClusterName());
            if (this.groupUuid != null) {
                builder.setUuid(this.groupUuid);
            }
            if (Objects.equals(this.groupUuid, responseUuid = (response = this.stub.callGroup(builder.build())).getUuid())) {
                return Optional.empty();
            }
            response.getGroupConfigTableList().forEach(rspGroupConfigItems -> {
                String groupName = rspGroupConfigItems.getGroupName();
                if (keys.contains(groupName)) {
                    GroupConfigTable.GroupConfigItems groupConfigItems = new GroupConfigTable.GroupConfigItems(groupName);
                    groupConfigTable.addGroupConfigItems(groupConfigItems);
                    rspGroupConfigItems.getItemsList().forEach(item -> groupConfigItems.add(new ConfigTable.ConfigItem(item.getName(), item.getValue())));
                }
            });
            this.groupUuid = responseUuid;
        }
        catch (Exception e) {
            log.error("Remote config center [{}] is not available.", (Object)this.settings, (Object)e);
        }
        return Optional.of(groupConfigTable);
    }
}

