/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.configmap;

import com.google.common.base.Strings;
import org.apache.skywalking.oap.server.configuration.api.AbstractConfigurationProvider;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigmapConfigurationSettings;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigmapConfigurationWatcherRegister;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigurationConfigmapInformer;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;

public class ConfigmapConfigurationProvider
extends AbstractConfigurationProvider {
    private ConfigmapConfigurationSettings settings;

    public String name() {
        return "k8s-configmap";
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<ConfigmapConfigurationSettings>(){

            public Class type() {
                return ConfigmapConfigurationSettings.class;
            }

            public void onInitialized(ConfigmapConfigurationSettings initialized) {
                ConfigmapConfigurationProvider.this.settings = initialized;
            }
        };
    }

    protected ConfigWatcherRegister initConfigReader() throws ModuleStartException {
        if (Strings.isNullOrEmpty((String)this.settings.getLabelSelector()) || Strings.isNullOrEmpty((String)this.settings.getNamespace())) {
            throw new ModuleStartException("the settings of configmap configuration is illegal.");
        }
        ConfigurationConfigmapInformer informer = new ConfigurationConfigmapInformer(this.settings);
        return new ConfigmapConfigurationWatcherRegister(this.settings, informer);
    }
}

