/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.starter;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.status.ServerStatusService;
import org.apache.skywalking.oap.server.core.version.Version;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.TerminalFriendlyTable;
import org.apache.skywalking.oap.server.starter.config.ApplicationConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAPServerBootstrap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAPServerBootstrap.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        ModuleManager manager = new ModuleManager("Apache SkyWalking OAP");
        TerminalFriendlyTable bootingParameters = manager.getBootingParameters();
        String mode = System.getProperty("mode");
        RunningMode.setMode((String)mode);
        ApplicationConfigLoader configLoader = new ApplicationConfigLoader(bootingParameters);
        bootingParameters.addRow(new TerminalFriendlyTable.Row("Running Mode", mode));
        bootingParameters.addRow(new TerminalFriendlyTable.Row("Version", Version.CURRENT.toString()));
        try {
            ApplicationConfiguration applicationConfiguration = configLoader.load();
            manager.init(applicationConfiguration);
            ((ServerStatusService)manager.find("core").provider().getService(ServerStatusService.class)).bootedNow(configLoader.getResolvedConfigurations(), System.currentTimeMillis());
            if (RunningMode.isInitMode()) {
                log.info("OAP starts up in init mode successfully, exit now...");
                System.exit(0);
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            System.exit(1);
        }
        finally {
            log.info(bootingParameters.toString());
        }
    }
}

