/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.google.protobuf.Message;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.grpc.DefaultUnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.JsonUnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.TextUnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorResponseType;
import com.linecorp.armeria.server.grpc.UnframedGrpcStatusMappingFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.curioswitch.common.protobuf.json.MessageMarshaller;

@UnstableApi
public final class UnframedGrpcErrorHandlerBuilder {
    private UnframedGrpcStatusMappingFunction statusMappingFunction = UnframedGrpcStatusMappingFunction.of();
    @Nullable
    private MessageMarshaller jsonMarshaller;
    @Nullable
    private List<Message> marshalledMessages;
    @Nullable
    private List<Class<? extends Message>> marshalledMessageTypes;
    @Nullable
    private Set<UnframedGrpcErrorResponseType> responseTypes;

    UnframedGrpcErrorHandlerBuilder() {
    }

    public UnframedGrpcErrorHandlerBuilder jsonMarshaller(MessageMarshaller jsonMarshaller) {
        Objects.requireNonNull(jsonMarshaller, "jsonMarshaller");
        Preconditions.checkState((this.marshalledMessages == null && this.marshalledMessageTypes == null ? 1 : 0) != 0, (Object)"Cannot set a custom JSON marshaller because one or more Message instances or Message types have already been registered. To set a custom marshaller, ensure that no Message or Message type registrations have been made before calling this method.");
        this.jsonMarshaller = jsonMarshaller;
        return this;
    }

    public UnframedGrpcErrorHandlerBuilder statusMappingFunction(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        this.statusMappingFunction = Objects.requireNonNull(statusMappingFunction, "statusMappingFunction");
        return this;
    }

    public UnframedGrpcErrorHandlerBuilder responseTypes(UnframedGrpcErrorResponseType ... responseTypes) {
        Objects.requireNonNull(responseTypes, "responseTypes");
        if (this.responseTypes == null) {
            this.responseTypes = EnumSet.noneOf(UnframedGrpcErrorResponseType.class);
        }
        Collections.addAll(this.responseTypes, responseTypes);
        return this;
    }

    public UnframedGrpcErrorHandlerBuilder registerMarshalledMessages(Message ... messages) {
        Objects.requireNonNull(messages, "messages");
        Preconditions.checkState((this.jsonMarshaller == null ? 1 : 0) != 0, (Object)"Cannot register custom messages because a custom JSON marshaller has already been set. Use the custom marshaller to register custom messages.");
        if (this.marshalledMessages == null) {
            this.marshalledMessages = new ArrayList<Message>();
        }
        Collections.addAll(this.marshalledMessages, messages);
        return this;
    }

    public UnframedGrpcErrorHandlerBuilder registerMarshalledMessages(Iterable<? extends Message> messages) {
        Objects.requireNonNull(messages, "messages");
        Preconditions.checkState((this.jsonMarshaller == null ? 1 : 0) != 0, (Object)"Cannot register the collection of messages because a custom JSON marshaller has already been set. Use the custom marshaller to register custom messages.");
        if (this.marshalledMessages == null) {
            this.marshalledMessages = new ArrayList<Message>();
        }
        messages.forEach(this.marshalledMessages::add);
        return this;
    }

    @SafeVarargs
    public final UnframedGrpcErrorHandlerBuilder registerMarshalledMessageTypes(Class<? extends Message> ... messageTypes) {
        Objects.requireNonNull(messageTypes, "messageTypes");
        Preconditions.checkState((this.jsonMarshaller == null ? 1 : 0) != 0, (Object)"Cannot register custom messageTypes because a custom JSON marshaller has already been set. Use the custom marshaller to register custom message types.");
        if (this.marshalledMessageTypes == null) {
            this.marshalledMessageTypes = new ArrayList<Class<? extends Message>>();
        }
        Collections.addAll(this.marshalledMessageTypes, messageTypes);
        return this;
    }

    public UnframedGrpcErrorHandlerBuilder registerMarshalledMessageTypes(Iterable<? extends Class<? extends Message>> messageTypes) {
        Objects.requireNonNull(messageTypes, "messageTypes");
        Preconditions.checkState((this.jsonMarshaller == null ? 1 : 0) != 0, (Object)"Cannot register the collection of messageTypes because a custom JSON marshaller has already been set. Use the custom marshaller to register custom message types.");
        if (this.marshalledMessageTypes == null) {
            this.marshalledMessageTypes = new ArrayList<Class<? extends Message>>();
        }
        messageTypes.forEach(this.marshalledMessageTypes::add);
        return this;
    }

    public UnframedGrpcErrorHandler build() {
        if (this.jsonMarshaller == null) {
            this.jsonMarshaller = JsonUnframedGrpcErrorHandler.ERROR_DETAILS_MARSHALLER;
            MessageMarshaller.Builder builder = this.jsonMarshaller.toBuilder();
            if (this.marshalledMessages != null) {
                for (Message message : this.marshalledMessages) {
                    builder.register(message);
                }
            }
            if (this.marshalledMessageTypes != null) {
                for (Class clazz : this.marshalledMessageTypes) {
                    builder.register(clazz);
                }
            }
            this.jsonMarshaller = builder.build();
        }
        if (this.responseTypes == null) {
            return DefaultUnframedGrpcErrorHandler.of(this.statusMappingFunction, this.jsonMarshaller);
        }
        if (this.responseTypes.contains((Object)UnframedGrpcErrorResponseType.JSON) && this.responseTypes.contains((Object)UnframedGrpcErrorResponseType.PLAINTEXT)) {
            return DefaultUnframedGrpcErrorHandler.of(this.statusMappingFunction, this.jsonMarshaller);
        }
        if (this.responseTypes.contains((Object)UnframedGrpcErrorResponseType.JSON)) {
            return JsonUnframedGrpcErrorHandler.of(this.statusMappingFunction, this.jsonMarshaller);
        }
        if (this.responseTypes.contains((Object)UnframedGrpcErrorResponseType.PLAINTEXT)) {
            return TextUnframedGrpcErrorHandler.of(this.statusMappingFunction);
        }
        return DefaultUnframedGrpcErrorHandler.of(this.statusMappingFunction, this.jsonMarshaller);
    }
}

