/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.gson.Gson;
import com.google.protobuf.GeneratedMessageV3;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.And;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.Or;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.Span;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.TopNQuery;
import org.apache.skywalking.banyandb.v1.client.TopNQueryResponse;
import org.apache.skywalking.banyandb.v1.client.Trace;
import org.apache.skywalking.banyandb.v1.client.TraceQuery;
import org.apache.skywalking.banyandb.v1.client.TraceQueryResponse;
import org.apache.skywalking.oap.server.core.query.input.AttrCondition;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.AbstractDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;

public abstract class AbstractBanyanDBDAO
extends AbstractDAO<BanyanDBStorageClient> {
    private static final Instant UPPER_BOUND = Instant.ofEpochSecond(0L, Long.MAX_VALUE);
    private static final TimestampRange LARGEST_TIME_RANGE = new TimestampRange(0L, UPPER_BOUND.toEpochMilli());
    protected static final long UPPER_BOUND_TIME = UPPER_BOUND.toEpochMilli();
    protected static final long LOWER_BOUND_TIME = 0L;

    protected AbstractBanyanDBDAO(BanyanDBStorageClient client) {
        super((Client)client);
    }

    protected StreamQueryResponse query(boolean isColdStage, String streamModelName, Set<String> tags, QueryBuilder<StreamQuery> builder) throws IOException {
        return this.query(isColdStage, streamModelName, tags, null, builder);
    }

    protected StreamQueryResponse query(boolean isColdStage, String streamModelName, Set<String> tags, TimestampRange timestampRange, QueryBuilder<StreamQuery> builder) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findRecordMetadata(streamModelName);
        if (schema == null) {
            throw new IllegalArgumentException("schema is not registered");
        }
        StreamQuery query = timestampRange == null ? new StreamQuery(List.of(schema.getMetadata().getGroup()), schema.getMetadata().name(), LARGEST_TIME_RANGE, tags) : new StreamQuery(List.of(schema.getMetadata().getGroup()), schema.getMetadata().name(), timestampRange, tags);
        if (isColdStage) {
            query.setStages(Set.of(BanyanDBStorageConfig.StageName.cold.name()));
        }
        builder.apply(query);
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        if (traceContext != null && traceContext.isDebug()) {
            query.enableTrace();
        }
        return ((BanyanDBStorageClient)this.getClient()).query(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamQueryResponse queryDebuggable(boolean isColdStage, String modelName, Set<String> tags, TimestampRange timestampRange, QueryBuilder<StreamQuery> queryBuilder) throws IOException {
        StreamQueryResponse streamQueryResponse;
        block5: {
            DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan span = null;
            try {
                StringBuilder builder = new StringBuilder();
                if (traceContext != null) {
                    span = traceContext.createSpan("Query BanyanDB Stream");
                    MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findRecordMetadata(modelName);
                    builder.append("Condition: ").append("modelName:").append(modelName).append(", Schema: ").append(schema).append(", Tags: ").append(tags).append(", TimestampRange: ").append(timestampRange).append(", Is cold data query: ").append(isColdStage);
                    span.setMsg(builder.toString());
                }
                StreamQueryResponse response = this.query(isColdStage, modelName, tags, timestampRange, queryBuilder);
                if (traceContext != null && traceContext.isDumpStorageRsp()) {
                    builder.append("\n").append(" Response: ").append(new Gson().toJson((Object)response.getElements()));
                    span.setMsg(builder.toString());
                }
                this.addDBTrace2DebuggingTrace(response.getTrace(), traceContext, span);
                streamQueryResponse = response;
                if (traceContext == null || span == null) break block5;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
            traceContext.stopSpan(span);
        }
        return streamQueryResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TopNQueryResponse topNQueryDebuggable(boolean isColdStage, MetadataRegistry.Schema schema, TimestampRange timestampRange, int number, AbstractQuery.Sort sort, List<KeyValue> additionalConditions, List<AttrCondition> attributes, String topNRuleName) throws IOException {
        TopNQueryResponse topNQueryResponse;
        block5: {
            DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan span = null;
            try {
                StringBuilder builder = new StringBuilder();
                if (traceContext != null) {
                    span = traceContext.createSpan("Query BanyanDB TopNQuery");
                    builder.append("Condition: ").append("Schema: ").append(schema).append(", TopNRuleName: ").append(topNRuleName).append(", TimestampRange: ").append(timestampRange).append(", Number: ").append(number).append(", Sort: ").append(sort).append(", AdditionalConditions: ").append(additionalConditions).append(", Attributes: ").append(attributes).append(", Is cold data query: ").append(isColdStage);
                    span.setMsg(builder.toString());
                }
                TopNQueryResponse response = this.topNQuery(isColdStage, schema, timestampRange, number, sort, additionalConditions, attributes, topNRuleName);
                if (traceContext != null && traceContext.isDumpStorageRsp()) {
                    builder.append("\n").append(" Response: ").append(new Gson().toJson((Object)response.getTopNLists()));
                    span.setMsg(builder.toString());
                }
                topNQueryResponse = response;
                if (traceContext == null || span == null) break block5;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
            traceContext.stopSpan(span);
        }
        return topNQueryResponse;
    }

    private TopNQueryResponse topNQuery(boolean isColdStage, MetadataRegistry.Schema schema, TimestampRange timestampRange, int number, AbstractQuery.Sort sort, List<KeyValue> additionalConditions, List<AttrCondition> attributes, String topNRuleName) throws IOException {
        TopNQuery q = new TopNQuery(List.of(schema.getMetadata().getGroup()), topNRuleName, timestampRange, number, sort);
        q.setAggregationType(MeasureQuery.Aggregation.Type.MEAN);
        ArrayList<PairQueryCondition> conditions = new ArrayList<PairQueryCondition>();
        if (CollectionUtils.isNotEmpty(additionalConditions)) {
            for (KeyValue kv : additionalConditions) {
                conditions.add(PairQueryCondition.StringQueryCondition.eq((String)kv.getKey(), (String)kv.getValue()));
            }
        }
        if (CollectionUtils.isNotEmpty(attributes)) {
            attributes.forEach(attr -> {
                if (attr.isEquals()) {
                    conditions.add(PairQueryCondition.StringQueryCondition.eq((String)attr.getKey(), (String)attr.getValue()));
                }
            });
        }
        q.setConditions(conditions);
        if (isColdStage) {
            q.setStages(List.of(BanyanDBStorageConfig.StageName.cold.name()));
        }
        return ((BanyanDBStorageClient)this.getClient()).query(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MeasureQueryResponse queryDebuggable(boolean isColdStage, MetadataRegistry.Schema schema, Set<String> tags, Set<String> fields, TimestampRange timestampRange, QueryBuilder<MeasureQuery> queryBuilder) throws IOException {
        MeasureQueryResponse measureQueryResponse;
        block5: {
            DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan span = null;
            try {
                StringBuilder builder = new StringBuilder();
                if (traceContext != null) {
                    span = traceContext.createSpan("Query BanyanDB Measure");
                    builder.append("Condition: ").append("Schema: ").append(schema).append(", Tags: ").append(tags).append(", Fields: ").append(fields).append(", TimestampRange: ").append(timestampRange).append(", Is cold data query: ").append(isColdStage);
                    span.setMsg(builder.toString());
                }
                MeasureQueryResponse response = this.query(isColdStage, schema, tags, fields, timestampRange, queryBuilder);
                if (traceContext != null && traceContext.isDumpStorageRsp()) {
                    builder.append("\n").append(" Response: ").append(new Gson().toJson((Object)response.getDataPoints()));
                    span.setMsg(builder.toString());
                }
                this.addDBTrace2DebuggingTrace(response.getTrace(), traceContext, span);
                measureQueryResponse = response;
                if (traceContext == null || span == null) break block5;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
            traceContext.stopSpan(span);
        }
        return measureQueryResponse;
    }

    protected MeasureQueryResponse query(boolean isColdStage, MetadataRegistry.Schema schema, Set<String> tags, Set<String> fields, QueryBuilder<MeasureQuery> builder) throws IOException {
        return this.query(isColdStage, schema, tags, fields, null, builder);
    }

    protected MeasureQueryResponse query(boolean isColdStage, MetadataRegistry.Schema schema, Set<String> tags, Set<String> fields, TimestampRange timestampRange, QueryBuilder<MeasureQuery> builder) throws IOException {
        if (schema == null) {
            throw new IllegalArgumentException("measure is not registered");
        }
        MeasureQuery query = timestampRange == null ? new MeasureQuery(List.of(schema.getMetadata().getGroup()), schema.getMetadata().name(), LARGEST_TIME_RANGE, tags, fields) : new MeasureQuery(List.of(schema.getMetadata().getGroup()), schema.getMetadata().name(), timestampRange, tags, fields);
        if (isColdStage) {
            query.setStages(Set.of(BanyanDBStorageConfig.StageName.cold.name()));
        }
        builder.apply(query);
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        if (traceContext != null && traceContext.isDebug()) {
            query.enableTrace();
        }
        return ((BanyanDBStorageClient)this.getClient()).query(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TraceQueryResponse queryTraceDebuggable(boolean isColdStage, String modelName, TimestampRange timestampRange, QueryBuilder<TraceQuery> queryBuilder) throws IOException {
        TraceQueryResponse traceQueryResponse;
        block5: {
            DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan span = null;
            try {
                StringBuilder builder = new StringBuilder();
                if (traceContext != null) {
                    span = traceContext.createSpan("Query BanyanDB Trace");
                    MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findRecordMetadata(modelName);
                    builder.append("Condition: ").append("modelName:").append(modelName).append(", Schema: ").append(schema).append(", TimestampRange: ").append(timestampRange).append(", Is cold data query: ").append(isColdStage);
                    span.setMsg(builder.toString());
                }
                TraceQueryResponse response = this.queryTrace(isColdStage, modelName, timestampRange, queryBuilder);
                if (traceContext != null && traceContext.isDumpStorageRsp()) {
                    builder.append("\n").append(" Response: ").append(new Gson().toJson((Object)response.getTraces()));
                    span.setMsg(builder.toString());
                }
                this.addDBTrace2DebuggingTrace(response.getTraceResult(), traceContext, span);
                traceQueryResponse = response;
                if (traceContext == null || span == null) break block5;
            }
            catch (Throwable throwable) {
                if (traceContext != null && span != null) {
                    traceContext.stopSpan(span);
                }
                throw throwable;
            }
            traceContext.stopSpan(span);
        }
        return traceQueryResponse;
    }

    private TraceQueryResponse queryTrace(boolean isColdStage, String traceModelName, TimestampRange timestampRange, QueryBuilder<TraceQuery> builder) throws IOException {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findRecordMetadata(traceModelName);
        if (schema == null) {
            throw new IllegalArgumentException("schema is not registered");
        }
        TraceQuery query = new TraceQuery(List.of(schema.getMetadata().getGroup()), schema.getMetadata().name(), timestampRange, Collections.emptySet());
        if (isColdStage) {
            query.setStages(Set.of(BanyanDBStorageConfig.StageName.cold.name()));
        }
        builder.apply(query);
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        if (traceContext != null && traceContext.isDebug()) {
            query.enableTrace();
        }
        return ((BanyanDBStorageClient)this.getClient()).query(query);
    }

    private void addDBTrace2DebuggingTrace(Trace trace, DebuggingTraceContext traceContext, DebuggingSpan parentSpan) {
        if (traceContext == null || parentSpan == null || trace == null) {
            return;
        }
        trace.getSpans().forEach(span -> this.addDBSpan2DebuggingTrace((Span)span, traceContext, parentSpan));
    }

    private void addDBSpan2DebuggingTrace(Span span, DebuggingTraceContext traceContext, DebuggingSpan parentSpan) {
        DebuggingSpan debuggingSpan = traceContext.createSpanForTransform("BanyanDB: " + span.getMessage());
        debuggingSpan.setStartTime(span.getStartTime().getSeconds() * 1000000000L + (long)span.getStartTime().getNanos());
        debuggingSpan.setEndTime(span.getEndTime().getSeconds() * 1000000000L + (long)span.getEndTime().getNanos());
        debuggingSpan.setDuration(span.getDuration());
        debuggingSpan.setParentSpanId(parentSpan.getSpanId());
        debuggingSpan.setMsg(span.getTags().toString());
        if (span.isError()) {
            debuggingSpan.setError("BanyanDB occurs error.");
        }
        span.getChildren().forEach(child -> this.addDBSpan2DebuggingTrace((Span)child, traceContext, debuggingSpan));
    }

    protected static QueryBuilder<MeasureQuery> emptyMeasureQuery() {
        return new QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
            }
        };
    }

    protected TimestampRange getTimestampRange(@Nullable Duration duration) {
        long startTimeMillis = 0L;
        long endTimeMillis = 0L;
        if (duration != null) {
            startTimeMillis = duration.getStartTimestamp();
            endTimeMillis = duration.getEndTimestamp();
        }
        TimestampRange tsRange = null;
        if (startTimeMillis > 0L && endTimeMillis > 0L) {
            tsRange = new TimestampRange(startTimeMillis, endTimeMillis);
        } else {
            Instant now = Instant.now();
            tsRange = new TimestampRange(now.minusMillis(86400000L).toEpochMilli(), now.toEpochMilli());
        }
        return tsRange;
    }

    protected static abstract class QueryBuilder<T extends AbstractQuery<? extends GeneratedMessageV3>> {
        protected QueryBuilder() {
        }

        protected abstract void apply(T var1);

        protected PairQueryCondition<Long> eq(String name, long value) {
            return PairQueryCondition.LongQueryCondition.eq((String)name, (Long)value);
        }

        protected PairQueryCondition<List<String>> having(String name, List<String> value) {
            return PairQueryCondition.StringArrayQueryCondition.having((String)name, value);
        }

        protected PairQueryCondition<Long> lte(String name, long value) {
            return PairQueryCondition.LongQueryCondition.le((String)name, (Long)value);
        }

        protected PairQueryCondition<Long> gte(String name, long value) {
            return PairQueryCondition.LongQueryCondition.ge((String)name, (Long)value);
        }

        protected PairQueryCondition<Long> gt(String name, long value) {
            return PairQueryCondition.LongQueryCondition.gt((String)name, (Long)value);
        }

        protected PairQueryCondition<String> eq(String name, String value) {
            return PairQueryCondition.StringQueryCondition.eq((String)name, (String)value);
        }

        protected PairQueryCondition<String> ne(String name, String value) {
            return PairQueryCondition.StringQueryCondition.ne((String)name, (String)value);
        }

        protected PairQueryCondition<String> match(String name, String value) {
            return PairQueryCondition.StringQueryCondition.match((String)name, (String)value);
        }

        protected PairQueryCondition<String> match(String name, String value, BanyandbModel.Condition.MatchOption matchOption) {
            return PairQueryCondition.StringQueryCondition.match((String)name, (String)value, (BanyandbModel.Condition.MatchOption)matchOption);
        }

        protected PairQueryCondition<List<String>> in(String name, List<String> values) {
            return PairQueryCondition.StringArrayQueryCondition.in((String)name, values);
        }

        protected PairQueryCondition<List<String>> notIn(String name, List<String> values) {
            return PairQueryCondition.StringArrayQueryCondition.in((String)name, values);
        }

        protected PairQueryCondition<Long> ne(String name, long value) {
            return PairQueryCondition.LongQueryCondition.ne((String)name, (Long)value);
        }

        protected AbstractCriteria and(List<? extends AbstractCriteria> conditions) {
            if (conditions.isEmpty()) {
                return null;
            }
            if (conditions.size() == 1) {
                return conditions.get(0);
            }
            return conditions.subList(2, conditions.size()).stream().reduce(And.create((AbstractCriteria)conditions.get(0), (AbstractCriteria)conditions.get(1)), And::create, And::create);
        }

        protected AbstractCriteria or(List<? extends AbstractCriteria> conditions) {
            if (conditions.isEmpty()) {
                return null;
            }
            if (conditions.size() == 1) {
                return conditions.get(0);
            }
            return conditions.subList(2, conditions.size()).stream().reduce(Or.create((AbstractCriteria)conditions.get(0), (AbstractCriteria)conditions.get(1)), Or::create, Or::create);
        }
    }
}

