/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.And;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.metadata.Duration;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntList;
import org.apache.skywalking.oap.server.core.config.DownSamplingConfigService;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.model.BanyanDBModelExtension;
import org.apache.skywalking.oap.server.core.storage.model.BanyanDBTrace;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MeasureModel;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.PropertyModel;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.StreamModel;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.TraceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetadataRegistry {
    INSTANCE;

    @Generated
    private static final Logger log;
    private final Map<String, Schema> registry = new HashMap<String, Schema>();

    public StreamModel registerStreamModel(Model model, BanyanDBStorageConfig config) {
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config, null);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        Map<String, ModelColumn> modelColumnMap = model.getColumns().stream().collect(Collectors.toMap(modelColumn -> modelColumn.getColumnName().getStorageName(), Function.identity()));
        List<String> seriesIDColumns = this.parseEntityNames(modelColumnMap);
        if (seriesIDColumns.isEmpty()) {
            throw new IllegalStateException("seriesID of model[stream." + model.getName() + "] must not be empty");
        }
        List<TagMetadata> tags = this.parseTagMetadata(model, schemaBuilder, seriesIDColumns, schemaMetadata.group);
        List<BanyandbDatabase.TagFamilySpec> tagFamilySpecs = schemaMetadata.extractTagFamilySpec(tags);
        for (BanyandbDatabase.TagFamilySpec tagFamilySpec : tagFamilySpecs) {
            for (BanyandbDatabase.TagSpec tagSpec : tagFamilySpec.getTagsList()) {
                schemaBuilder.tag(tagSpec.getName());
            }
        }
        String timestampColumn4Stream = model.getBanyanDBModelExtension().getTimestampColumn();
        if (StringUtil.isBlank((String)timestampColumn4Stream)) {
            throw new IllegalStateException("Model[stream." + model.getName() + "] miss defined @BanyanDB.TimestampColumn");
        }
        schemaBuilder.timestampColumn(timestampColumn4Stream);
        List<BanyandbDatabase.IndexRule> indexRules = tags.stream().map(TagMetadata::getIndexRule).filter(Objects::nonNull).collect(Collectors.toList());
        BanyandbDatabase.Stream.Builder builder = BanyandbDatabase.Stream.newBuilder();
        builder.setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schemaMetadata.getGroup()).setName(schemaMetadata.name()));
        builder.setEntity(BanyandbDatabase.Entity.newBuilder().addAllTagNames(seriesIDColumns));
        builder.addAllTagFamilies(tagFamilySpecs);
        this.registry.put(schemaMetadata.name(), schemaBuilder.build());
        return new StreamModel(builder.build(), indexRules);
    }

    public MeasureModel registerMeasureModel(Model model, BanyanDBStorageConfig config, DownSamplingConfigService configService) throws StorageException {
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config, configService);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        Map<String, ModelColumn> modelColumnMap = model.getColumns().stream().collect(Collectors.toMap(modelColumn -> modelColumn.getColumnName().getStorageName(), Function.identity()));
        List<String> seriesIDColumns = this.parseEntityNames(modelColumnMap);
        List<String> shardingKeyColumns = this.parseShardingKeyNames(modelColumnMap);
        boolean isIndexMode = model.getBanyanDBModelExtension().isIndexMode();
        if (isIndexMode) {
            seriesIDColumns.add("id");
        }
        if (seriesIDColumns.isEmpty()) {
            throw new StorageException("model " + model.getName() + " doesn't contain series id");
        }
        MeasureMetadata tagsAndFields = this.parseTagAndFieldMetadata(model, schemaBuilder, seriesIDColumns, schemaMetadata.group, isIndexMode);
        List<BanyandbDatabase.TagFamilySpec> tagFamilySpecs = schemaMetadata.extractTagFamilySpec(tagsAndFields.tags);
        Set<String> tags = tagFamilySpecs.stream().flatMap(tagFamilySpec -> tagFamilySpec.getTagsList().stream()).map(BanyandbDatabase.TagSpec::getName).collect(Collectors.toSet());
        schemaBuilder.tags(tags);
        List<BanyandbDatabase.IndexRule> indexRules = tagsAndFields.tags.stream().map(TagMetadata::getIndexRule).filter(Objects::nonNull).collect(Collectors.toList());
        BanyandbDatabase.Measure.Builder builder = BanyandbDatabase.Measure.newBuilder();
        builder.setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schemaMetadata.getGroup()).setName(schemaMetadata.name()));
        builder.setInterval(this.downSamplingDuration(model.getDownsampling()).format());
        builder.setEntity(BanyandbDatabase.Entity.newBuilder().addAllTagNames(seriesIDColumns));
        if (CollectionUtils.isNotEmpty(shardingKeyColumns)) {
            builder.setShardingKey(BanyandbDatabase.ShardingKey.newBuilder().addAllTagNames(shardingKeyColumns));
        }
        builder.addAllTagFamilies(tagFamilySpecs);
        if (model.getBanyanDBModelExtension().isIndexMode()) {
            builder.setIndexMode(true);
            if (!tagsAndFields.fields.isEmpty()) {
                throw new StorageException("index mode is enabled, but fields are defined");
            }
        }
        for (BanyandbDatabase.FieldSpec field : tagsAndFields.fields) {
            builder.addFields(field);
            schemaBuilder.field(field.getName());
        }
        schemaBuilder.topNSpecs(this.parseTopNSpecs(model, schemaMetadata.group, schemaMetadata.name(), config.getTopNConfigs().get(model.getName()), tags));
        this.registry.put(schemaMetadata.name(), schemaBuilder.build());
        return new MeasureModel(builder.build(), indexRules);
    }

    public PropertyModel registerPropertyModel(Model model, BanyanDBStorageConfig config) {
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config, null);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        List<TagMetadata> tags = this.parseTagMetadata(model, schemaBuilder, Collections.emptyList(), schemaMetadata.group);
        BanyandbDatabase.Property.Builder builder = BanyandbDatabase.Property.newBuilder();
        builder.setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schemaMetadata.getGroup()).setName(schemaMetadata.name()));
        for (TagMetadata tag : tags) {
            builder.addTags(tag.getTagSpec());
        }
        this.registry.put(schemaMetadata.name(), schemaBuilder.build());
        return new PropertyModel(builder.build());
    }

    public TraceModel registerTraceModel(Model model, BanyanDBStorageConfig config) {
        SchemaMetadata schemaMetadata = this.parseMetadata(model, config, null);
        Schema.SchemaBuilder schemaBuilder = Schema.builder().metadata(schemaMetadata);
        String timestampColumn = model.getBanyanDBModelExtension().getTimestampColumn();
        schemaBuilder.timestampColumn(timestampColumn);
        BanyandbDatabase.Trace.Builder builder = BanyandbDatabase.Trace.newBuilder();
        builder.setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(schemaMetadata.getGroup()).setName(schemaMetadata.name()));
        builder.setTraceIdTagName(model.getBanyanDBModelExtension().getTraceIdColumn());
        builder.setTimestampTagName(timestampColumn);
        builder.setSpanIdTagName(model.getBanyanDBModelExtension().getSpanIdColumn());
        for (ModelColumn col : model.getColumns()) {
            String columnStorageName = col.getColumnName().getStorageName();
            if (!col.getBanyanDBExtension().shouldIndex() || columnStorageName.equals("time_bucket")) continue;
            BanyandbDatabase.TagSpec tagSpec = this.parseTagSpec(col);
            BanyandbDatabase.TraceTagSpec.Builder traceTagSpec = BanyandbDatabase.TraceTagSpec.newBuilder();
            traceTagSpec.setName(tagSpec.getName());
            traceTagSpec.setType(tagSpec.getType());
            if (columnStorageName.equals(timestampColumn)) {
                traceTagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_TIMESTAMP);
            }
            builder.addTags(traceTagSpec.build());
            schemaBuilder.spec(columnStorageName, new ColumnSpec(ColumnType.TAG, col.getType()));
            schemaBuilder.tag(tagSpec.getName());
        }
        List traceIndexRules = model.getBanyanDBModelExtension().getTraceIndexRules();
        ArrayList<BanyandbDatabase.IndexRule> indexRules = null;
        if (!BanyanDBTrace.MergeTable.class.isAssignableFrom(model.getStreamClass())) {
            if (CollectionUtils.isEmpty((List)traceIndexRules)) {
                throw new IllegalStateException("Model[trace." + model.getName() + "] miss defined @BanyanDB.Trace.IndexRuleColumns");
            }
            indexRules = new ArrayList<BanyandbDatabase.IndexRule>(traceIndexRules.size());
            for (BanyanDBModelExtension.TraceIndexRule traceIndexRule : traceIndexRules) {
                BanyandbDatabase.IndexRule.Builder indexRule = BanyandbDatabase.IndexRule.newBuilder().setType(BanyandbDatabase.IndexRule.Type.TYPE_TREE).setNoSort(false).setMetadata(BanyandbCommon.Metadata.newBuilder().setName(traceIndexRule.getName()).setGroup(schemaMetadata.getGroup())).addAllTags(List.of(traceIndexRule.getColumns())).addTags(traceIndexRule.getOrderByColumn());
                indexRules.add(indexRule.build());
            }
        }
        this.registry.put(schemaMetadata.name(), schemaBuilder.build());
        return new TraceModel(builder.build(), indexRules);
    }

    private Map<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> parseTopNSpecs(Model model, String group, String measureName, Map<String, BanyanDBStorageConfig.TopN> topNConfig, Set<String> tags) throws StorageException {
        if (topNConfig == null) {
            return null;
        }
        Optional valueColumnOpt = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(model.getName());
        if (valueColumnOpt.isEmpty() || ((ValueColumnMetadata.ValueColumn)valueColumnOpt.get()).getDataType() != Column.ValueDataType.COMMON_VALUE) {
            return null;
        }
        HashMap<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> topNAggregations = new HashMap<ImmutableSet<String>, BanyandbDatabase.TopNAggregation>();
        topNConfig.forEach((name, topN) -> {
            ImmutableSet key = ImmutableSet.of();
            HashSet<Object> queryConditions = new HashSet<Object>();
            BanyandbDatabase.TopNAggregation.Builder topNAggregation = BanyandbDatabase.TopNAggregation.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(name)).setSourceMeasure(BanyandbCommon.Metadata.newBuilder().setGroup(group).setName(measureName)).setFieldValueSort(topN.getSort().getBanyandbSort()).setFieldName(((ValueColumnMetadata.ValueColumn)valueColumnOpt.get()).getValueCName()).setCountersNumber(topN.getCountersNumber());
            if (topN.getGroupByTagNames() != null) {
                queryConditions.addAll(topN.getGroupByTagNames());
                topN.getGroupByTagNames().forEach(tag -> {
                    if (!tags.contains(tag)) {
                        throw new IllegalArgumentException("In file [bydb-topn.yml], TopN rule " + topN.getName() + "'s groupByTagName [" + tag + "] is not defined in metric " + model.getName());
                    }
                });
                topNAggregation.addAllGroupByTagNames(topN.getGroupByTagNames());
            }
            switch (model.getDownsampling()) {
                case Minute: {
                    topNAggregation.setLruSize(topN.getLruSizeMinute());
                    break;
                }
                case Hour: 
                case Day: {
                    topNAggregation.setLruSize(topN.getLruSizeHourDay());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported downsampling: " + String.valueOf(model.getDownsampling()));
                }
            }
            if (CollectionUtils.isNotEmpty(topN.getExcludes())) {
                ArrayList<PairQueryCondition> conditions = new ArrayList<PairQueryCondition>(topN.getExcludes().size());
                for (KeyValue keyValue : topN.getExcludes()) {
                    conditions.add(PairQueryCondition.StringQueryCondition.ne((String)keyValue.getKey(), (String)keyValue.getValue()));
                    queryConditions.remove(keyValue.getKey());
                    queryConditions.add(keyValue.getKey() + "!=" + keyValue.getValue());
                }
                AbstractCriteria criteria = conditions.size() == 1 ? (AbstractCriteria)conditions.get(0) : conditions.subList(2, conditions.size()).stream().reduce(And.create((AbstractCriteria)((AbstractCriteria)conditions.get(0)), (AbstractCriteria)((AbstractCriteria)conditions.get(1))), And::create, And::create);
                topNAggregation.setCriteria(criteria.build());
            }
            if (topNAggregations.containsKey(key = ImmutableSet.copyOf(queryConditions))) {
                throw new IllegalArgumentException("In file [bydb-topn.yml], TopN rule " + topN.getName() + "'s groupByTagNames and excludes " + String.valueOf(key) + " already exist in the same metric " + model.getName());
            }
            topNAggregations.put(key, topNAggregation.build());
        });
        return topNAggregations;
    }

    static DownSampling deriveFromStep(Step step) {
        switch (step) {
            case DAY: {
                return DownSampling.Day;
            }
            case HOUR: {
                return DownSampling.Hour;
            }
            case SECOND: {
                return DownSampling.Second;
            }
        }
        return DownSampling.Minute;
    }

    public Schema findMetricMetadata(String modelName, Step step) {
        return this.findMetricMetadata(modelName, MetadataRegistry.deriveFromStep(step));
    }

    public Schema findMetricMetadata(String modelName, DownSampling downSampling) {
        return this.registry.get(SchemaMetadata.formatName(modelName, downSampling));
    }

    public Schema findRecordMetadata(String modelName) {
        return this.registry.get(modelName);
    }

    public Schema findManagementMetadata(String modelName) {
        return this.registry.get(modelName);
    }

    public Schema findMetadata(Model model) {
        if (!model.isTimeSeries()) {
            return this.findManagementMetadata(model.getName());
        }
        if (model.isRecord()) {
            return this.findRecordMetadata(model.getName());
        }
        return this.findMetricMetadata(model.getName(), model.getDownsampling());
    }

    private BanyandbDatabase.FieldSpec parseFieldSpec(ModelColumn modelColumn) {
        String colName = modelColumn.getColumnName().getStorageName();
        if (String.class.equals((Object)modelColumn.getType())) {
            return BanyandbDatabase.FieldSpec.newBuilder().setName(colName).setFieldType(BanyandbDatabase.FieldType.FIELD_TYPE_STRING).setCompressionMethod(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_ZSTD).build();
        }
        if (Long.TYPE.equals(modelColumn.getType()) || Integer.TYPE.equals(modelColumn.getType())) {
            return BanyandbDatabase.FieldSpec.newBuilder().setName(colName).setFieldType(BanyandbDatabase.FieldType.FIELD_TYPE_INT).setCompressionMethod(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_ZSTD).setEncodingMethod(BanyandbDatabase.EncodingMethod.ENCODING_METHOD_GORILLA).build();
        }
        if (StorageDataComplexObject.class.isAssignableFrom(modelColumn.getType()) || JsonObject.class.equals((Object)modelColumn.getType())) {
            return BanyandbDatabase.FieldSpec.newBuilder().setName(colName).setFieldType(BanyandbDatabase.FieldType.FIELD_TYPE_STRING).setCompressionMethod(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_ZSTD).build();
        }
        if (Double.TYPE.equals(modelColumn.getType())) {
            log.warn("Double is stored as binary");
            return BanyandbDatabase.FieldSpec.newBuilder().setName(colName).setFieldType(BanyandbDatabase.FieldType.FIELD_TYPE_DATA_BINARY).setCompressionMethod(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_ZSTD).build();
        }
        throw new UnsupportedOperationException(modelColumn.getType().getSimpleName() + " is not supported for field");
    }

    Duration downSamplingDuration(DownSampling downSampling) {
        switch (downSampling) {
            case Hour: {
                return Duration.ofHours((long)1L);
            }
            case Minute: {
                return Duration.ofMinutes((long)1L);
            }
            case Day: {
                return Duration.ofHours((long)24L);
            }
        }
        throw new UnsupportedOperationException("unsupported downSampling interval");
    }

    BanyandbDatabase.IndexRule indexRule(String group, String tagName, boolean enableSort, BanyanDB.MatchQuery.AnalyzerType analyzer, BanyanDB.IndexRule.IndexType type) {
        BanyandbDatabase.IndexRule.Builder builder;
        block13: {
            block12: {
                builder = BanyandbDatabase.IndexRule.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setName(tagName).setGroup(group)).addTags(tagName);
                builder.setNoSort(!enableSort);
                if (type == null) break block12;
                switch (type) {
                    case INVERTED: {
                        builder.setType(BanyandbDatabase.IndexRule.Type.TYPE_INVERTED);
                        break block13;
                    }
                    case TREE: {
                        builder.setType(BanyandbDatabase.IndexRule.Type.TYPE_TREE);
                        break block13;
                    }
                    case SKIPPING: {
                        builder.setType(BanyandbDatabase.IndexRule.Type.TYPE_SKIPPING);
                        break block13;
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupported index type: " + String.valueOf(type));
                    }
                }
            }
            builder.setType(BanyandbDatabase.IndexRule.Type.TYPE_INVERTED);
        }
        if (analyzer != null) {
            switch (analyzer) {
                case KEYWORD: {
                    builder.setAnalyzer("keyword");
                    break;
                }
                case STANDARD: {
                    builder.setAnalyzer("standard");
                    break;
                }
                case SIMPLE: {
                    builder.setAnalyzer("simple");
                    break;
                }
                case URL: {
                    builder.setAnalyzer("url");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported analyzer type: " + String.valueOf(analyzer));
                }
            }
        }
        return builder.build();
    }

    List<String> parseEntityNames(Map<String, ModelColumn> modelColumnMap) {
        ArrayList<ModelColumn> seriesIDColumns = new ArrayList<ModelColumn>();
        for (ModelColumn col2 : modelColumnMap.values()) {
            if (!col2.getBanyanDBExtension().isSeriesID()) continue;
            seriesIDColumns.add(col2);
        }
        return seriesIDColumns.stream().sorted(Comparator.comparingInt(col -> col.getBanyanDBExtension().getSeriesIDIdx())).map(col -> col.getColumnName().getName()).collect(Collectors.toList());
    }

    List<String> parseShardingKeyNames(Map<String, ModelColumn> modelColumnMap) {
        ArrayList<ModelColumn> shardingKeyColumns = new ArrayList<ModelColumn>();
        for (ModelColumn col2 : modelColumnMap.values()) {
            if (!col2.getBanyanDBExtension().isShardingKey()) continue;
            shardingKeyColumns.add(col2);
        }
        return shardingKeyColumns.stream().sorted(Comparator.comparingInt(col -> col.getBanyanDBExtension().getShardingKeyIdx())).map(col -> col.getColumnName().getName()).collect(Collectors.toList());
    }

    List<TagMetadata> parseTagMetadata(Model model, Schema.SchemaBuilder builder, List<String> seriesIDColumns, String group) {
        ArrayList<TagMetadata> tagMetadataList = new ArrayList<TagMetadata>();
        for (ModelColumn col : model.getColumns()) {
            String columnStorageName = col.getColumnName().getStorageName();
            if (columnStorageName.equals("time_bucket")) continue;
            BanyandbDatabase.TagSpec tagSpec = this.parseTagSpec(col);
            builder.spec(columnStorageName, new ColumnSpec(ColumnType.TAG, col.getType()));
            String colName = col.getColumnName().getStorageName();
            if (col.getBanyanDBExtension().shouldIndex() && !colName.equals(model.getBanyanDBModelExtension().getTimestampColumn())) {
                if (!seriesIDColumns.contains(colName) || null != col.getBanyanDBExtension().getAnalyzer()) {
                    tagMetadataList.add(new TagMetadata(this.indexRule(group, tagSpec.getName(), col.getBanyanDBExtension().isEnableSort(), col.getBanyanDBExtension().getAnalyzer(), col.getBanyanDBExtension().getIndexType()), tagSpec));
                    continue;
                }
                tagMetadataList.add(new TagMetadata(null, tagSpec));
                continue;
            }
            tagMetadataList.add(new TagMetadata(null, tagSpec));
        }
        return tagMetadataList;
    }

    MeasureMetadata parseTagAndFieldMetadata(Model model, Schema.SchemaBuilder builder, List<String> seriesIDColumns, String group, boolean shouldAddID) {
        MeasureMetadata.MeasureMetadataBuilder result = MeasureMetadata.builder();
        for (ModelColumn col : model.getColumns()) {
            String columnStorageName = col.getColumnName().getStorageName();
            if (columnStorageName.equals("time_bucket")) continue;
            if (col.getBanyanDBExtension().isMeasureField()) {
                builder.spec(columnStorageName, new ColumnSpec(ColumnType.FIELD, col.getType()));
                result.field(this.parseFieldSpec(col));
                continue;
            }
            BanyandbDatabase.TagSpec tagSpec = this.parseTagSpec(col);
            builder.spec(columnStorageName, new ColumnSpec(ColumnType.TAG, col.getType()));
            String colName = col.getColumnName().getStorageName();
            if (col.getBanyanDBExtension().shouldIndex() && !colName.equals(model.getBanyanDBModelExtension().getTimestampColumn())) {
                if (!seriesIDColumns.contains(colName) || null != col.getBanyanDBExtension().getAnalyzer()) {
                    result.tag(new TagMetadata(this.indexRule(group, tagSpec.getName(), col.getBanyanDBExtension().isEnableSort(), col.getBanyanDBExtension().getAnalyzer(), col.getBanyanDBExtension().getIndexType()), tagSpec));
                    continue;
                }
                result.tag(new TagMetadata(null, tagSpec));
                continue;
            }
            result.tag(new TagMetadata(null, tagSpec));
        }
        if (shouldAddID) {
            result.tag(new TagMetadata(null, BanyandbDatabase.TagSpec.newBuilder().setType(BanyandbDatabase.TagType.TAG_TYPE_STRING).setName("id").build()));
        }
        return result.build();
    }

    @Nonnull
    private BanyandbDatabase.TagSpec parseTagSpec(ModelColumn modelColumn) {
        Class clazz = modelColumn.getType();
        String colName = modelColumn.getColumnName().getStorageName();
        BanyandbDatabase.TagSpec.Builder tagSpec = BanyandbDatabase.TagSpec.newBuilder().setName(colName);
        if (String.class.equals((Object)clazz) || StorageDataComplexObject.class.isAssignableFrom(clazz) || JsonObject.class.equals((Object)clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_STRING);
        } else if (Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Integer.class.equals((Object)clazz) || Long.class.equals((Object)clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_INT);
        } else if (byte[].class.equals((Object)clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_DATA_BINARY);
        } else if (clazz.isEnum()) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_INT);
        } else if (Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_DATA_BINARY);
        } else if (IntList.class.isAssignableFrom(clazz)) {
            tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_INT_ARRAY);
        } else if (List.class.isAssignableFrom(clazz)) {
            ParameterizedType t = (ParameterizedType)modelColumn.getGenericType();
            if (String.class.equals((Object)t.getActualTypeArguments()[0])) {
                tagSpec = tagSpec.setType(BanyandbDatabase.TagType.TAG_TYPE_STRING_ARRAY);
            }
        } else {
            throw new IllegalStateException("type " + modelColumn.getType().toString() + " is not supported");
        }
        return tagSpec.build();
    }

    public SchemaMetadata parseMetadata(Model model, BanyanDBStorageConfig config, DownSamplingConfigService configService) {
        String namespace = config.getGlobal().getNamespace();
        if (!model.isTimeSeries()) {
            return new SchemaMetadata(namespace, BanyanDB.PropertyGroup.PROPERTY.getName(), model.getName(), Kind.PROPERTY, DownSampling.None, config.getProperty());
        }
        if (model.isRecord()) {
            BanyanDB.TraceGroup traceGroup = model.getBanyanDBModelExtension().getTraceGroup();
            if (BanyanDB.TraceGroup.NONE != traceGroup) {
                switch (traceGroup) {
                    case TRACE: {
                        return new SchemaMetadata(namespace, BanyanDB.TraceGroup.TRACE.getName(), model.getName(), Kind.TRACE, DownSampling.None, config.getTrace());
                    }
                    case ZIPKIN_TRACE: {
                        return new SchemaMetadata(namespace, BanyanDB.TraceGroup.ZIPKIN_TRACE.getName(), model.getName(), Kind.TRACE, DownSampling.None, config.getZipkinTrace());
                    }
                }
                throw new IllegalStateException("unknown trace group " + String.valueOf(traceGroup));
            }
            BanyanDB.StreamGroup streamGroup = model.getBanyanDBModelExtension().getStreamGroup();
            switch (streamGroup) {
                case RECORDS_LOG: {
                    return new SchemaMetadata(namespace, BanyanDB.StreamGroup.RECORDS_LOG.getName(), model.getName(), Kind.STREAM, model.getDownsampling(), config.getRecordsLog());
                }
                case RECORDS_BROWSER_ERROR_LOG: {
                    return new SchemaMetadata(namespace, BanyanDB.StreamGroup.RECORDS_BROWSER_ERROR_LOG.getName(), model.getName(), Kind.STREAM, model.getDownsampling(), config.getRecordsBrowserErrorLog());
                }
                case RECORDS: {
                    return new SchemaMetadata(namespace, BanyanDB.StreamGroup.RECORDS.getName(), model.getName(), Kind.STREAM, model.getDownsampling(), config.getRecordsBrowserErrorLog());
                }
            }
            throw new IllegalStateException("unknown stream group " + String.valueOf(streamGroup));
        }
        if (model.getBanyanDBModelExtension().isIndexMode()) {
            return new SchemaMetadata(namespace, BanyanDB.MeasureGroup.METADATA.getName(), model.getName(), Kind.MEASURE, model.getDownsampling(), config.getMetadata());
        }
        switch (model.getDownsampling()) {
            case Minute: {
                return new SchemaMetadata(namespace, BanyanDB.MeasureGroup.METRICS_MINUTE.getName(), model.getName(), Kind.MEASURE, model.getDownsampling(), config.getMetricsMin());
            }
            case Hour: {
                if (!configService.shouldToHour()) {
                    throw new UnsupportedOperationException("downsampling to hour is not supported");
                }
                return new SchemaMetadata(namespace, BanyanDB.MeasureGroup.METRICS_HOUR.getName(), model.getName(), Kind.MEASURE, model.getDownsampling(), config.getMetricsHour());
            }
            case Day: {
                if (!configService.shouldToDay()) {
                    throw new UnsupportedOperationException("downsampling to day is not supported");
                }
                return new SchemaMetadata(namespace, BanyanDB.MeasureGroup.METRICS_DAY.getName(), model.getName(), Kind.MEASURE, model.getDownsampling(), config.getMetricsDay());
            }
        }
        throw new UnsupportedOperationException("unsupported downSampling interval:" + String.valueOf(model.getDownsampling()));
    }

    public static String convertGroupName(String namespace, String groupName) {
        if (StringUtil.isNotEmpty((String)namespace)) {
            return namespace + "_" + groupName;
        }
        return groupName;
    }

    static {
        log = LoggerFactory.getLogger(MetadataRegistry.class);
    }

    public static class SchemaMetadata {
        private final String namespace;
        private final String group;
        private final String modelName;
        private final Kind kind;
        private final DownSampling downSampling;
        private final BanyanDBStorageConfig.GroupResource resource;

        public SchemaMetadata(String namespace, String group, String modelName, Kind kind, DownSampling downSampling, BanyanDBStorageConfig.GroupResource resource) {
            this.namespace = namespace;
            this.modelName = modelName;
            this.kind = kind;
            this.downSampling = downSampling;
            this.resource = resource;
            this.group = MetadataRegistry.convertGroupName(namespace, group);
        }

        static String formatName(String modelName, DownSampling downSampling) {
            if (downSampling == null || downSampling == DownSampling.None) {
                return modelName;
            }
            return modelName + "_" + downSampling.getName();
        }

        private List<BanyandbDatabase.TagFamilySpec> extractTagFamilySpec(List<TagMetadata> tagMetadataList) {
            String indexFamily = this.indexFamily();
            String nonIndexFamily = this.nonIndexFamily();
            Map<String, List<TagMetadata>> tagMetadataMap = tagMetadataList.stream().collect(Collectors.groupingBy(tagMetadata -> tagMetadata.isIndex() ? indexFamily : nonIndexFamily));
            ArrayList<BanyandbDatabase.TagFamilySpec> tagFamilySpecs = new ArrayList<BanyandbDatabase.TagFamilySpec>(tagMetadataMap.size());
            for (Map.Entry<String, List<TagMetadata>> entry : tagMetadataMap.entrySet()) {
                BanyandbDatabase.TagFamilySpec.Builder b = BanyandbDatabase.TagFamilySpec.newBuilder();
                b.setName(entry.getKey());
                b.addAllTags((Iterable)entry.getValue().stream().map(TagMetadata::getTagSpec).collect(Collectors.toList()));
                tagFamilySpecs.add(b.build());
            }
            return tagFamilySpecs;
        }

        public String name() {
            if (this.kind == Kind.MEASURE) {
                return SchemaMetadata.formatName(this.modelName, this.downSampling);
            }
            return this.modelName;
        }

        public String indexFamily() {
            switch (this.kind.ordinal()) {
                case 0: {
                    return "default";
                }
                case 1: {
                    return "searchable";
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        public String nonIndexFamily() {
            switch (this.kind.ordinal()) {
                case 0: 
                case 1: {
                    return "storage-only";
                }
            }
            throw new IllegalStateException("should not reach here");
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getModelName() {
            return this.modelName;
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        @Generated
        public DownSampling getDownSampling() {
            return this.downSampling;
        }

        @Generated
        public BanyanDBStorageConfig.GroupResource getResource() {
            return this.resource;
        }

        @Generated
        public String toString() {
            return "MetadataRegistry.SchemaMetadata(namespace=" + this.getNamespace() + ", group=" + this.getGroup() + ", modelName=" + this.getModelName() + ", kind=" + String.valueOf((Object)this.getKind()) + ", downSampling=" + String.valueOf(this.getDownSampling()) + ", resource=" + String.valueOf(this.getResource()) + ")";
        }
    }

    public static class Schema {
        private final SchemaMetadata metadata;
        private final Map<String, ColumnSpec> specs;
        private final Set<String> tags;
        private final Set<String> fields;
        private final String timestampColumn;
        @Nullable
        private final Map<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> topNSpecs;

        public ColumnSpec getSpec(String columnName) {
            return this.specs.get(columnName);
        }

        @Generated
        Schema(SchemaMetadata metadata, Map<String, ColumnSpec> specs, Set<String> tags, Set<String> fields, String timestampColumn, @Nullable Map<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> topNSpecs) {
            this.metadata = metadata;
            this.specs = specs;
            this.tags = tags;
            this.fields = fields;
            this.timestampColumn = timestampColumn;
            this.topNSpecs = topNSpecs;
        }

        @Generated
        public static SchemaBuilder builder() {
            return new SchemaBuilder();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Schema)) {
                return false;
            }
            Schema other = (Schema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SchemaMetadata this$metadata = this.getMetadata();
            SchemaMetadata other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
                return false;
            }
            Map<String, ColumnSpec> this$specs = this.specs;
            Map<String, ColumnSpec> other$specs = other.specs;
            if (this$specs == null ? other$specs != null : !((Object)this$specs).equals(other$specs)) {
                return false;
            }
            Set<String> this$tags = this.getTags();
            Set<String> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            Set<String> this$fields = this.getFields();
            Set<String> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            String this$timestampColumn = this.getTimestampColumn();
            String other$timestampColumn = other.getTimestampColumn();
            if (this$timestampColumn == null ? other$timestampColumn != null : !this$timestampColumn.equals(other$timestampColumn)) {
                return false;
            }
            Map<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> this$topNSpecs = this.getTopNSpecs();
            Map<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> other$topNSpecs = other.getTopNSpecs();
            return !(this$topNSpecs == null ? other$topNSpecs != null : !((Object)this$topNSpecs).equals(other$topNSpecs));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Schema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SchemaMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
            Map<String, ColumnSpec> $specs = this.specs;
            result = result * 59 + ($specs == null ? 43 : ((Object)$specs).hashCode());
            Set<String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            Set<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            String $timestampColumn = this.getTimestampColumn();
            result = result * 59 + ($timestampColumn == null ? 43 : $timestampColumn.hashCode());
            Map<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> $topNSpecs = this.getTopNSpecs();
            result = result * 59 + ($topNSpecs == null ? 43 : ((Object)$topNSpecs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetadataRegistry.Schema(metadata=" + String.valueOf(this.getMetadata()) + ", specs=" + String.valueOf(this.specs) + ", tags=" + String.valueOf(this.getTags()) + ", fields=" + String.valueOf(this.getFields()) + ", timestampColumn=" + this.getTimestampColumn() + ", topNSpecs=" + String.valueOf(this.getTopNSpecs()) + ")";
        }

        @Generated
        public SchemaMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public Set<String> getTags() {
            return this.tags;
        }

        @Generated
        public Set<String> getFields() {
            return this.fields;
        }

        @Generated
        public String getTimestampColumn() {
            return this.timestampColumn;
        }

        @Nullable
        @Generated
        public Map<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> getTopNSpecs() {
            return this.topNSpecs;
        }

        @Generated
        public static class SchemaBuilder {
            @Generated
            private SchemaMetadata metadata;
            @Generated
            private ArrayList<String> specs$key;
            @Generated
            private ArrayList<ColumnSpec> specs$value;
            @Generated
            private ArrayList<String> tags;
            @Generated
            private ArrayList<String> fields;
            @Generated
            private String timestampColumn;
            @Generated
            private Map<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> topNSpecs;

            @Generated
            SchemaBuilder() {
            }

            @Generated
            public SchemaBuilder metadata(SchemaMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public SchemaBuilder spec(String specKey, ColumnSpec specValue) {
                if (this.specs$key == null) {
                    this.specs$key = new ArrayList();
                    this.specs$value = new ArrayList();
                }
                this.specs$key.add(specKey);
                this.specs$value.add(specValue);
                return this;
            }

            @Generated
            public SchemaBuilder specs(Map<? extends String, ? extends ColumnSpec> specs) {
                if (specs == null) {
                    throw new NullPointerException("specs cannot be null");
                }
                if (this.specs$key == null) {
                    this.specs$key = new ArrayList();
                    this.specs$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends ColumnSpec> $lombokEntry : specs.entrySet()) {
                    this.specs$key.add($lombokEntry.getKey());
                    this.specs$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @Generated
            public SchemaBuilder clearSpecs() {
                if (this.specs$key != null) {
                    this.specs$key.clear();
                    this.specs$value.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder tag(String tag) {
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.add(tag);
                return this;
            }

            @Generated
            public SchemaBuilder tags(Collection<? extends String> tags) {
                if (tags == null) {
                    throw new NullPointerException("tags cannot be null");
                }
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.addAll(tags);
                return this;
            }

            @Generated
            public SchemaBuilder clearTags() {
                if (this.tags != null) {
                    this.tags.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder field(String field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @Generated
            public SchemaBuilder fields(Collection<? extends String> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            @Generated
            public SchemaBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @Generated
            public SchemaBuilder timestampColumn(String timestampColumn) {
                this.timestampColumn = timestampColumn;
                return this;
            }

            @Generated
            public SchemaBuilder topNSpecs(@Nullable Map<ImmutableSet<String>, BanyandbDatabase.TopNAggregation> topNSpecs) {
                this.topNSpecs = topNSpecs;
                return this;
            }

            @Generated
            public Schema build() {
                Set<Object> fields;
                Set<Object> tags;
                Map<Object, Object> specs;
                switch (this.specs$key == null ? 0 : this.specs$key.size()) {
                    case 0: {
                        specs = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        specs = Collections.singletonMap(this.specs$key.get(0), this.specs$value.get(0));
                        break;
                    }
                    default: {
                        specs = new LinkedHashMap(this.specs$key.size() < 0x40000000 ? 1 + this.specs$key.size() + (this.specs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.specs$key.size(); ++$i) {
                            specs.put(this.specs$key.get($i), this.specs$value.get($i));
                        }
                        specs = Collections.unmodifiableMap(specs);
                    }
                }
                switch (this.tags == null ? 0 : this.tags.size()) {
                    case 0: {
                        tags = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        tags = Collections.singleton(this.tags.get(0));
                        break;
                    }
                    default: {
                        tags = new LinkedHashSet(this.tags.size() < 0x40000000 ? 1 + this.tags.size() + (this.tags.size() - 3) / 3 : Integer.MAX_VALUE);
                        tags.addAll(this.tags);
                        tags = Collections.unmodifiableSet(tags);
                    }
                }
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        fields = Collections.singleton(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = new LinkedHashSet(this.fields.size() < 0x40000000 ? 1 + this.fields.size() + (this.fields.size() - 3) / 3 : Integer.MAX_VALUE);
                        fields.addAll(this.fields);
                        fields = Collections.unmodifiableSet(fields);
                    }
                }
                return new Schema(this.metadata, specs, tags, fields, this.timestampColumn, this.topNSpecs);
            }

            @Generated
            public String toString() {
                return "MetadataRegistry.Schema.SchemaBuilder(metadata=" + String.valueOf(this.metadata) + ", specs$key=" + String.valueOf(this.specs$key) + ", specs$value=" + String.valueOf(this.specs$value) + ", tags=" + String.valueOf(this.tags) + ", fields=" + String.valueOf(this.fields) + ", timestampColumn=" + this.timestampColumn + ", topNSpecs=" + String.valueOf(this.topNSpecs) + ")";
            }
        }
    }

    private static class MeasureMetadata {
        private final List<TagMetadata> tags;
        private final List<BanyandbDatabase.FieldSpec> fields;

        @Generated
        MeasureMetadata(List<TagMetadata> tags, List<BanyandbDatabase.FieldSpec> fields) {
            this.tags = tags;
            this.fields = fields;
        }

        @Generated
        public static MeasureMetadataBuilder builder() {
            return new MeasureMetadataBuilder();
        }

        @Generated
        public static class MeasureMetadataBuilder {
            @Generated
            private ArrayList<TagMetadata> tags;
            @Generated
            private ArrayList<BanyandbDatabase.FieldSpec> fields;

            @Generated
            MeasureMetadataBuilder() {
            }

            @Generated
            public MeasureMetadataBuilder tag(TagMetadata tag) {
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.add(tag);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder tags(Collection<? extends TagMetadata> tags) {
                if (tags == null) {
                    throw new NullPointerException("tags cannot be null");
                }
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.addAll(tags);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder clearTags() {
                if (this.tags != null) {
                    this.tags.clear();
                }
                return this;
            }

            @Generated
            public MeasureMetadataBuilder field(BanyandbDatabase.FieldSpec field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder fields(Collection<? extends BanyandbDatabase.FieldSpec> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            @Generated
            public MeasureMetadataBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @Generated
            public MeasureMetadata build() {
                List<BanyandbDatabase.FieldSpec> fields;
                List<TagMetadata> tags;
                switch (this.tags == null ? 0 : this.tags.size()) {
                    case 0: {
                        tags = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        tags = Collections.singletonList(this.tags.get(0));
                        break;
                    }
                    default: {
                        tags = Collections.unmodifiableList(new ArrayList<TagMetadata>(this.tags));
                    }
                }
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fields = Collections.singletonList(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = Collections.unmodifiableList(new ArrayList<BanyandbDatabase.FieldSpec>(this.fields));
                    }
                }
                return new MeasureMetadata(tags, fields);
            }

            @Generated
            public String toString() {
                return "MetadataRegistry.MeasureMetadata.MeasureMetadataBuilder(tags=" + String.valueOf(this.tags) + ", fields=" + String.valueOf(this.fields) + ")";
            }
        }
    }

    private static class TagMetadata {
        private final BanyandbDatabase.IndexRule indexRule;
        private final BanyandbDatabase.TagSpec tagSpec;

        boolean isIndex() {
            return this.indexRule != null;
        }

        @Generated
        public TagMetadata(BanyandbDatabase.IndexRule indexRule, BanyandbDatabase.TagSpec tagSpec) {
            this.indexRule = indexRule;
            this.tagSpec = tagSpec;
        }

        @Generated
        public BanyandbDatabase.IndexRule getIndexRule() {
            return this.indexRule;
        }

        @Generated
        public BanyandbDatabase.TagSpec getTagSpec() {
            return this.tagSpec;
        }
    }

    public static class ColumnSpec {
        private final ColumnType columnType;
        private final Class<?> columnClass;

        @Generated
        public ColumnSpec(ColumnType columnType, Class<?> columnClass) {
            this.columnType = columnType;
            this.columnClass = columnClass;
        }

        @Generated
        public ColumnType getColumnType() {
            return this.columnType;
        }

        @Generated
        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        @Generated
        public String toString() {
            return "MetadataRegistry.ColumnSpec(columnType=" + String.valueOf((Object)this.getColumnType()) + ", columnClass=" + String.valueOf(this.getColumnClass()) + ")";
        }
    }

    public static enum ColumnType {
        TAG,
        FIELD;

    }

    public static enum Kind {
        MEASURE,
        STREAM,
        PROPERTY,
        TRACE;

    }
}

