/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.unsafe;

import com.linecorp.armeria.common.Bytes;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.websocket.CloseWebSocketFrame;
import com.linecorp.armeria.common.websocket.WebSocketFrame;

@UnstableApi
public final class PooledObjects {
    public static void close(Object obj) {
        if (obj instanceof Bytes) {
            ((Bytes)obj).close();
        }
    }

    public static <T> T touch(T obj) {
        return PooledObjects.touch(obj, obj);
    }

    public static <T> T touch(T obj, @Nullable Object hint) {
        if (obj instanceof Bytes) {
            ((Bytes)obj).touch(hint);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T copyAndClose(T obj) {
        WebSocketFrame frame;
        HttpData data;
        if (obj instanceof HttpData && (data = (HttpData)obj).isPooled()) {
            try {
                HttpData copy;
                HttpData httpData = copy = HttpData.wrap(data.array()).withEndOfStream(data.isEndOfStream());
                return (T)httpData;
            }
            finally {
                data.close();
            }
        }
        if (obj instanceof WebSocketFrame && (frame = (WebSocketFrame)obj).isPooled()) {
            return PooledObjects.copyAndCloseWebSocketFrame(frame);
        }
        return obj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T copyAndCloseWebSocketFrame(WebSocketFrame frame) {
        try {
            switch (frame.type()) {
                case CONTINUATION: {
                    WebSocketFrame webSocketFrame = WebSocketFrame.ofContinuation(frame.array(), frame.isFinalFragment());
                    return (T)webSocketFrame;
                }
                case TEXT: {
                    WebSocketFrame webSocketFrame = WebSocketFrame.ofText(frame.array(), frame.isFinalFragment());
                    return (T)webSocketFrame;
                }
                case BINARY: {
                    WebSocketFrame webSocketFrame = WebSocketFrame.ofBinary(frame.array(), frame.isFinalFragment());
                    return (T)webSocketFrame;
                }
                case CLOSE: {
                    CloseWebSocketFrame closeWebSocketFrame = WebSocketFrame.ofClose(frame.array());
                    return (T)closeWebSocketFrame;
                }
                case PING: {
                    WebSocketFrame webSocketFrame = WebSocketFrame.ofPing(frame.array());
                    return (T)webSocketFrame;
                }
                case PONG: {
                    WebSocketFrame webSocketFrame = WebSocketFrame.ofPong(frame.array());
                    return (T)webSocketFrame;
                }
            }
            throw new Error();
        }
        finally {
            frame.close();
        }
    }

    private PooledObjects() {
    }
}

