/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.stream.ByteStreamMessage;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamWriter;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ByteStreamMessageOutputStream
implements ByteStreamMessage {
    private final StreamWriter<HttpData> outputStreamWriter = StreamMessage.streaming();
    private final ByteStreamMessage delegate = ByteStreamMessage.of(this.outputStreamWriter);
    private final Consumer<? super OutputStream> outputStreamConsumer;
    private final Executor blockingTaskExecutor;

    ByteStreamMessageOutputStream(Consumer<? super OutputStream> outputStreamConsumer, Executor blockingTaskExecutor) {
        Objects.requireNonNull(outputStreamConsumer, "outputStreamConsumer");
        Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.outputStreamConsumer = outputStreamConsumer;
        this.blockingTaskExecutor = blockingTaskExecutor;
    }

    @Override
    public ByteStreamMessage range(long offset, long length) {
        this.delegate.range(offset, length);
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public long demand() {
        return this.delegate.demand();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.delegate.whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super HttpData> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        OutputStreamSubscriber outputStreamSubscriber = new OutputStreamSubscriber(subscriber, this.outputStreamWriter, this.outputStreamConsumer, this.blockingTaskExecutor);
        this.delegate.subscribe(outputStreamSubscriber, executor, options);
    }

    @Override
    public void abort() {
        this.delegate.abort();
    }

    @Override
    public void abort(Throwable cause) {
        this.delegate.abort(cause);
    }

    private static final class OutputStreamSubscriber
    implements Subscriber<HttpData> {
        private final Subscriber<? super HttpData> downstream;
        private final StreamWriter<HttpData> outputStreamWriter;
        private final Consumer<? super OutputStream> outputStreamConsumer;
        private final Executor blockingTaskExecutor;

        OutputStreamSubscriber(Subscriber<? super HttpData> downstream, StreamWriter<HttpData> outputStreamWriter, Consumer<? super OutputStream> outputStreamConsumer, Executor blockingTaskExecutor) {
            Objects.requireNonNull(downstream, "downstream");
            Objects.requireNonNull(outputStreamWriter, "outputStreamWriter");
            Objects.requireNonNull(outputStreamConsumer, "outputStreamConsumer");
            Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
            this.downstream = downstream;
            this.outputStreamWriter = outputStreamWriter;
            this.outputStreamConsumer = outputStreamConsumer;
            this.blockingTaskExecutor = blockingTaskExecutor;
        }

        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription");
            this.downstream.onSubscribe(subscription);
            this.blockingTaskExecutor.execute(() -> {
                try {
                    this.outputStreamConsumer.accept(new StreamWriterOutputStream(this.outputStreamWriter));
                }
                catch (Throwable t) {
                    this.outputStreamWriter.abort(t);
                }
            });
        }

        public void onNext(HttpData data) {
            Objects.requireNonNull(data, "data");
            this.downstream.onNext((Object)data);
        }

        public void onError(Throwable t) {
            Objects.requireNonNull(t, "t");
            this.downstream.onError(t);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }
    }

    private static final class StreamWriterOutputStream
    extends OutputStream {
        private final StreamWriter<HttpData> streamWriter;

        StreamWriterOutputStream(StreamWriter<HttpData> streamWriter) {
            this.streamWriter = streamWriter;
        }

        @Override
        public void write(int b) throws IOException {
            HttpData data = HttpData.wrap(new byte[]{(byte)b});
            if (!this.streamWriter.tryWrite(data)) {
                throw new IOException("Stream closed");
            }
            this.streamWriter.whenConsumed().join();
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            HttpData data = HttpData.copyOf(bytes, off, len);
            if (!this.streamWriter.tryWrite(data)) {
                throw new IOException("Stream closed");
            }
            this.streamWriter.whenConsumed().join();
        }

        @Override
        public void close() throws IOException {
            this.streamWriter.close();
        }
    }
}

