/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.logging.ClientConnectionTimingsBuilder;
import com.linecorp.armeria.common.util.TextFormatter;
import java.util.concurrent.TimeUnit;

public final class ClientConnectionTimings {
    static final int TO_STRING_BUILDER_CAPACITY = 466;
    private final long connectionAcquisitionStartTimeMicros;
    private final long connectionAcquisitionDurationNanos;
    private final long dnsResolutionStartTimeMicros;
    private final long dnsResolutionDurationNanos;
    private final long socketConnectStartTimeMicros;
    private final long socketConnectDurationNanos;
    private final long tlsHandshakeStartTimeMicros;
    private final long tlsHandshakeDurationNanos;
    private final long pendingAcquisitionStartTimeMicros;
    private final long pendingAcquisitionDurationNanos;

    public static ClientConnectionTimingsBuilder builder() {
        return new ClientConnectionTimingsBuilder();
    }

    ClientConnectionTimings(long connectionAcquisitionStartTimeMicros, long connectionAcquisitionDurationNanos, long dnsResolutionStartTimeMicros, long dnsResolutionDurationNanos, long socketConnectStartTimeMicros, long socketConnectDurationNanos, long tlsHandshakeStartTimeMicros, long tlsHandshakeDurationNanos, long pendingAcquisitionStartTimeMicros, long pendingAcquisitionDurationNanos) {
        this.connectionAcquisitionStartTimeMicros = connectionAcquisitionStartTimeMicros;
        this.connectionAcquisitionDurationNanos = connectionAcquisitionDurationNanos;
        this.dnsResolutionStartTimeMicros = dnsResolutionStartTimeMicros;
        this.dnsResolutionDurationNanos = dnsResolutionDurationNanos;
        this.socketConnectStartTimeMicros = socketConnectStartTimeMicros;
        this.socketConnectDurationNanos = socketConnectDurationNanos;
        this.tlsHandshakeStartTimeMicros = tlsHandshakeStartTimeMicros;
        this.tlsHandshakeDurationNanos = tlsHandshakeDurationNanos;
        this.pendingAcquisitionStartTimeMicros = pendingAcquisitionStartTimeMicros;
        this.pendingAcquisitionDurationNanos = pendingAcquisitionDurationNanos;
    }

    public long connectionAcquisitionStartTimeMicros() {
        return this.connectionAcquisitionStartTimeMicros;
    }

    public long connectionAcquisitionStartTimeMillis() {
        return TimeUnit.MICROSECONDS.toMillis(this.connectionAcquisitionStartTimeMicros);
    }

    public long connectionAcquisitionDurationNanos() {
        return this.connectionAcquisitionDurationNanos;
    }

    public long dnsResolutionStartTimeMicros() {
        return this.dnsResolutionStartTimeMicros;
    }

    public long dnsResolutionStartTimeMillis() {
        return ClientConnectionTimings.toMillis(this.dnsResolutionStartTimeMicros);
    }

    public long dnsResolutionDurationNanos() {
        return this.dnsResolutionDurationNanos;
    }

    public long socketConnectStartTimeMicros() {
        return this.socketConnectStartTimeMicros;
    }

    public long socketConnectStartTimeMillis() {
        return ClientConnectionTimings.toMillis(this.socketConnectStartTimeMicros);
    }

    public long socketConnectDurationNanos() {
        return this.socketConnectDurationNanos;
    }

    public long tlsHandshakeStartTimeMicros() {
        return this.tlsHandshakeStartTimeMicros;
    }

    public long tlsHandshakeStartTimeMillis() {
        return ClientConnectionTimings.toMillis(this.tlsHandshakeStartTimeMicros);
    }

    public long tlsHandshakeDurationNanos() {
        return this.tlsHandshakeDurationNanos;
    }

    public long pendingAcquisitionStartTimeMicros() {
        return this.pendingAcquisitionStartTimeMicros;
    }

    public long pendingAcquisitionStartTimeMillis() {
        return ClientConnectionTimings.toMillis(this.pendingAcquisitionStartTimeMicros);
    }

    public long pendingAcquisitionDurationNanos() {
        return this.pendingAcquisitionDurationNanos;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(466);
        buf.append("{connectionAcquisitionStartTime=");
        TextFormatter.appendEpochMicros(buf, this.connectionAcquisitionStartTimeMicros);
        buf.append(", connectionAcquisitionDuration=");
        TextFormatter.appendElapsed(buf, this.connectionAcquisitionDurationNanos);
        if (this.dnsResolutionDurationNanos >= 0L) {
            buf.append(", dnsResolutionStartTime=");
            TextFormatter.appendEpochMicros(buf, this.dnsResolutionStartTimeMicros);
            buf.append(", dnsResolutionDuration=");
            TextFormatter.appendElapsed(buf, this.dnsResolutionDurationNanos);
        }
        if (this.socketConnectDurationNanos >= 0L) {
            buf.append(", socketConnectStartTime=");
            TextFormatter.appendEpochMicros(buf, this.socketConnectStartTimeMicros);
            buf.append(", socketConnectDuration=");
            TextFormatter.appendElapsed(buf, this.socketConnectDurationNanos);
        }
        if (this.tlsHandshakeDurationNanos >= 0L) {
            buf.append(", tlsHandshakeStartTime=");
            TextFormatter.appendEpochMicros(buf, this.tlsHandshakeStartTimeMicros);
            buf.append(", tlsHandshakeDuration=");
            TextFormatter.appendElapsed(buf, this.tlsHandshakeDurationNanos);
        }
        if (this.pendingAcquisitionDurationNanos >= 0L) {
            buf.append(", pendingAcquisitionStartTime=");
            TextFormatter.appendEpochMicros(buf, this.pendingAcquisitionStartTimeMicros);
            buf.append(", pendingAcquisitionDuration=");
            TextFormatter.appendElapsed(buf, this.pendingAcquisitionDurationNanos);
        }
        buf.append('}');
        return buf.toString();
    }

    private static long toMillis(long micro) {
        if (micro >= 0L) {
            return TimeUnit.MICROSECONDS.toMillis(micro);
        }
        return -1L;
    }
}

