/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.internal.common.DefaultCancellationScheduler;
import com.linecorp.armeria.internal.common.NoopCancellationScheduler;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;

public interface CancellationScheduler {
    public static final CancellationTask noopCancellationTask = cause -> {};

    public static CancellationScheduler ofClient(long timeoutNanos) {
        timeoutNanos = DefaultCancellationScheduler.translateTimeoutNanos(timeoutNanos);
        return new DefaultCancellationScheduler(timeoutNanos, false);
    }

    public static CancellationScheduler ofServer(long timeoutNanos) {
        timeoutNanos = DefaultCancellationScheduler.translateTimeoutNanos(timeoutNanos);
        return new DefaultCancellationScheduler(timeoutNanos, true);
    }

    public static CancellationScheduler finished(boolean server) {
        if (server) {
            return DefaultCancellationScheduler.serverFinishedCancellationScheduler;
        }
        return DefaultCancellationScheduler.clientFinishedCancellationScheduler;
    }

    public static CancellationScheduler noop() {
        return NoopCancellationScheduler.INSTANCE;
    }

    public void initAndStart(EventExecutor var1, CancellationTask var2);

    public void init(EventExecutor var1);

    public void start();

    public void clearTimeout();

    public boolean cancelScheduled();

    public boolean isScheduled();

    public void setTimeoutNanos(TimeoutMode var1, long var2);

    default public void finishNow() {
        this.finishNow(null);
    }

    public void finishNow(@Nullable Throwable var1);

    public boolean isFinished();

    @Nullable
    public Throwable cause();

    public long timeoutNanos();

    public long remainingTimeoutNanos();

    public long startTimeNanos();

    public CompletableFuture<Throwable> whenCancelling();

    public CompletableFuture<Throwable> whenCancelled();

    public void updateTask(CancellationTask var1);

    public State state();

    @FunctionalInterface
    public static interface CancellationTask {
        default public boolean canSchedule() {
            return true;
        }

        public void run(Throwable var1);
    }

    public static enum State {
        INIT,
        SCHEDULED,
        FINISHED;

    }
}

