/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener;

import lombok.Generated;
import org.apache.skywalking.apm.network.language.agent.v3.ErrorCategory;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppPageTraffic;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppSingleVersionTraffic;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppTraffic;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppTrafficCategory;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppTrafficSource;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorCategory;
import org.apache.skywalking.oap.server.core.config.NamingControl;

class SourceBuilder {
    private final NamingControl namingControl;
    private String service;
    private String serviceVersion;
    private String patePath;
    private long timeBucket;
    private BrowserAppTrafficCategory trafficCategory;
    private BrowserErrorCategory errorCategory;

    public void setService(String service) {
        this.service = this.namingControl.formatServiceName(service);
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = this.namingControl.formatInstanceName(serviceVersion);
    }

    public void setPatePath(String patePath) {
        this.patePath = this.namingControl.formatEndpointName(this.service, patePath);
    }

    public void setErrorCategory(ErrorCategory category) {
        this.errorCategory = BrowserErrorCategory.fromErrorCategory((ErrorCategory)category);
    }

    private void toBrowserAppTrafficSource(BrowserAppTrafficSource source) {
        source.setTimeBucket(this.timeBucket);
        source.setTrafficCategory(this.trafficCategory);
        source.setErrorCategory(this.errorCategory);
    }

    BrowserAppTraffic toBrowserAppTraffic() {
        BrowserAppTraffic traffic = new BrowserAppTraffic();
        this.toBrowserAppTrafficSource((BrowserAppTrafficSource)traffic);
        traffic.setName(this.service);
        traffic.setTrafficCategory(this.trafficCategory);
        traffic.setErrorCategory(this.errorCategory);
        return traffic;
    }

    BrowserAppSingleVersionTraffic toBrowserAppSingleVersionTraffic() {
        BrowserAppSingleVersionTraffic traffic = new BrowserAppSingleVersionTraffic();
        this.toBrowserAppTrafficSource((BrowserAppTrafficSource)traffic);
        traffic.setName(this.serviceVersion);
        traffic.setServiceName(this.service);
        return traffic;
    }

    BrowserAppPageTraffic toBrowserAppPageTraffic() {
        BrowserAppPageTraffic traffic = new BrowserAppPageTraffic();
        this.toBrowserAppTrafficSource((BrowserAppTrafficSource)traffic);
        traffic.setName(this.patePath);
        traffic.setServiceName(this.service);
        return traffic;
    }

    @Generated
    public SourceBuilder(NamingControl namingControl) {
        this.namingControl = namingControl;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    @Generated
    public String getPatePath() {
        return this.patePath;
    }

    @Generated
    public void setTimeBucket(long timeBucket) {
        this.timeBucket = timeBucket;
    }

    @Generated
    public long getTimeBucket() {
        return this.timeBucket;
    }

    @Generated
    public void setTrafficCategory(BrowserAppTrafficCategory trafficCategory) {
        this.trafficCategory = trafficCategory;
    }

    @Generated
    public BrowserAppTrafficCategory getTrafficCategory() {
        return this.trafficCategory;
    }

    @Generated
    public BrowserErrorCategory getErrorCategory() {
        return this.errorCategory;
    }
}

