/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.event.grpc;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.event.v3.Event;
import org.apache.skywalking.apm.network.event.v3.EventServiceGrpc;
import org.apache.skywalking.oap.server.analyzer.event.EventAnalyzerService;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGrpcServiceHandler
extends EventServiceGrpc.EventServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventGrpcServiceHandler.class);
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;
    private final EventAnalyzerService eventAnalyzerService;

    public EventGrpcServiceHandler(ModuleManager moduleManager) {
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.eventAnalyzerService = (EventAnalyzerService)moduleManager.find("event-analyzer").provider().getService(EventAnalyzerService.class);
        this.histogram = metricsCreator.createHistogramMetric("event_in_latency", "The process latency of event data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("event_error_count", "The error number of event analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}));
    }

    public StreamObserver<Event> collect(final StreamObserver<Commands> responseObserver) {
        return new StreamObserver<Event>(){

            public void onNext(Event event) {
                try (HistogramMetrics.Timer ignored = EventGrpcServiceHandler.this.histogram.createTimer();){
                    String errMsg = null;
                    if (event.getLayer().isEmpty()) {
                        errMsg = "Layer field is required since v9.0.0, please upgrade your event report tools";
                    }
                    try {
                        Layer.nameOf((String)event.getLayer());
                    }
                    catch (UnexpectedException e) {
                        errMsg = e.getMessage();
                    }
                    if (errMsg != null) {
                        responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(errMsg).asException());
                        return;
                    }
                    EventGrpcServiceHandler.this.eventAnalyzerService.analyze(event);
                }
                catch (Exception e) {
                    EventGrpcServiceHandler.this.errorCounter.inc();
                    log.error(e.getMessage(), (Throwable)e);
                }
            }

            public void onError(Throwable throwable) {
                Status status = Status.fromThrowable((Throwable)throwable);
                if (Status.CANCELLED.getCode() == status.getCode()) {
                    if (log.isDebugEnabled()) {
                        log.debug(throwable.getMessage(), throwable);
                    }
                    return;
                }
                log.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

