/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Internal;
import graphql.org.antlr.v4.runtime.CharStream;
import graphql.org.antlr.v4.runtime.Token;
import graphql.org.antlr.v4.runtime.TokenFactory;
import graphql.org.antlr.v4.runtime.TokenSource;
import java.util.function.BiConsumer;

@Internal
public class SafeTokenSource
implements TokenSource {
    private final TokenSource lexer;
    private final int maxTokens;
    private final int maxWhitespaceTokens;
    private final BiConsumer<Integer, Token> whenMaxTokensExceeded;
    private final int[] channelCounts;

    public SafeTokenSource(TokenSource lexer, int maxTokens, int maxWhitespaceTokens, BiConsumer<Integer, Token> whenMaxTokensExceeded) {
        this.lexer = lexer;
        this.maxTokens = maxTokens;
        this.maxWhitespaceTokens = maxWhitespaceTokens;
        this.whenMaxTokensExceeded = whenMaxTokensExceeded;
        this.channelCounts = new int[]{0, 0, 0, 0, 0};
    }

    @Override
    public Token nextToken() {
        Token token = this.lexer.nextToken();
        if (token != null) {
            int channel;
            int n = channel = token.getChannel();
            int n2 = this.channelCounts[n] + 1;
            this.channelCounts[n] = n2;
            int currentCount = n2;
            if (channel == 3) {
                this.callbackIfMaxExceeded(this.maxWhitespaceTokens, currentCount, token);
            } else {
                this.callbackIfMaxExceeded(this.maxTokens, currentCount, token);
            }
        }
        return token;
    }

    private void callbackIfMaxExceeded(int maxCount, int currentCount, Token token) {
        if (currentCount > maxCount) {
            this.whenMaxTokensExceeded.accept(maxCount, token);
        }
    }

    @Override
    public int getLine() {
        return this.lexer.getLine();
    }

    @Override
    public int getCharPositionInLine() {
        return this.lexer.getCharPositionInLine();
    }

    @Override
    public CharStream getInputStream() {
        return this.lexer.getInputStream();
    }

    @Override
    public String getSourceName() {
        return this.lexer.getSourceName();
    }

    @Override
    public void setTokenFactory(TokenFactory<?> factory) {
        this.lexer.setTokenFactory(factory);
    }

    @Override
    public TokenFactory<?> getTokenFactory() {
        return this.lexer.getTokenFactory();
    }
}

