/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.browser.source.BrowserErrorCategory;
import org.apache.skywalking.oap.server.core.query.PaginationUtils;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.BrowserErrorLogs;
import org.apache.skywalking.oap.server.core.query.type.ErrorCategory;
import org.apache.skywalking.oap.server.core.query.type.Pagination;
import org.apache.skywalking.oap.server.core.storage.query.IBrowserLogQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;

public class BrowserLogQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IBrowserLogQueryDAO browserLogQueryDAO;

    private IBrowserLogQueryDAO getBrowserLogQueryDAO() {
        return Optional.ofNullable(this.browserLogQueryDAO).orElseGet(() -> {
            this.browserLogQueryDAO = (IBrowserLogQueryDAO)this.moduleManager.find("storage").provider().getService(IBrowserLogQueryDAO.class);
            return this.browserLogQueryDAO;
        });
    }

    public BrowserErrorLogs queryBrowserErrorLogs(String serviceId, String serviceVersionId, String pagePathId, ErrorCategory category, Duration duration, Pagination paging) throws IOException {
        PaginationUtils.Page page = PaginationUtils.INSTANCE.exchange(paging);
        BrowserErrorCategory errorCategory = Optional.ofNullable(category).filter(c -> c != ErrorCategory.ALL).map(c -> BrowserErrorCategory.valueOf(c.name())).orElse(null);
        return this.getBrowserLogQueryDAO().queryBrowserErrorLogs(serviceId, serviceVersionId, pagePathId, errorCategory, duration, page.getLimit(), page.getFrom());
    }

    @Generated
    public BrowserLogQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

