/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.relation.instance;

import org.apache.skywalking.oap.server.core.analysis.SourceDispatcher;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.instance.ServiceInstanceRelationClientSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.manual.relation.instance.ServiceInstanceRelationServerSideMetrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.source.TCPServiceInstanceRelation;

public class TCPServiceInstanceCallRelationDispatcher
implements SourceDispatcher<TCPServiceInstanceRelation> {
    @Override
    public void dispatch(TCPServiceInstanceRelation source) {
        switch (source.getDetectPoint()) {
            case SERVER: {
                this.serverSide(source);
                break;
            }
            case CLIENT: {
                this.clientSide(source);
            }
        }
    }

    private void serverSide(TCPServiceInstanceRelation source) {
        ServiceInstanceRelationServerSideMetrics metrics = new ServiceInstanceRelationServerSideMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setSourceServiceId(source.getSourceServiceId());
        metrics.setSourceServiceInstanceId(source.getSourceServiceInstanceId());
        metrics.setDestServiceId(source.getDestServiceId());
        metrics.setDestServiceInstanceId(source.getDestServiceInstanceId());
        metrics.setEntityId(source.getEntityId());
        MetricsStreamProcessor.getInstance().in(metrics);
    }

    private void clientSide(TCPServiceInstanceRelation source) {
        ServiceInstanceRelationClientSideMetrics metrics = new ServiceInstanceRelationClientSideMetrics();
        metrics.setTimeBucket(source.getTimeBucket());
        metrics.setSourceServiceId(source.getSourceServiceId());
        metrics.setSourceServiceInstanceId(source.getSourceServiceInstanceId());
        metrics.setDestServiceId(source.getDestServiceId());
        metrics.setDestServiceInstanceId(source.getDestServiceInstanceId());
        metrics.setEntityId(source.getEntityId());
        MetricsStreamProcessor.getInstance().in(metrics);
    }
}

