/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.oap.query.graphql.AsyncQueryUtils;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileTaskQueryService;
import org.apache.skywalking.oap.server.core.query.input.SegmentProfileAnalyzeQuery;
import org.apache.skywalking.oap.server.core.query.type.ProfileAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.ProfileTask;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLog;
import org.apache.skywalking.oap.server.core.query.type.ProfiledTraceSegments;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class ProfileQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private ProfileTaskQueryService profileTaskQueryService;

    public ProfileQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private ProfileTaskQueryService getProfileTaskQueryService() {
        if (this.profileTaskQueryService == null) {
            this.profileTaskQueryService = (ProfileTaskQueryService)this.moduleManager.find("core").provider().getService(ProfileTaskQueryService.class);
        }
        return this.profileTaskQueryService;
    }

    public CompletableFuture<List<ProfileTask>> getProfileTaskList(String serviceId, String endpointName) {
        return AsyncQueryUtils.queryAsync(() -> this.getProfileTaskQueryService().getTaskList(serviceId, endpointName));
    }

    public CompletableFuture<List<ProfileTaskLog>> getProfileTaskLogs(String taskID) {
        return AsyncQueryUtils.queryAsync(() -> this.getProfileTaskQueryService().getProfileTaskLogs(taskID));
    }

    public CompletableFuture<List<ProfiledTraceSegments>> getProfileTaskSegments(String taskId) {
        return AsyncQueryUtils.queryAsync(() -> this.getProfileTaskQueryService().getProfileTaskSegments(taskId));
    }

    public CompletableFuture<ProfileAnalyzation> getSegmentsProfileAnalyze(List<SegmentProfileAnalyzeQuery> queries) {
        return AsyncQueryUtils.queryAsync(() -> this.getProfileTaskQueryService().getProfileAnalyze(queries));
    }
}

