/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleFilesChangeMonitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultipleFilesChangeMonitor.class);
    private static ScheduledFuture<?> FILE_MONITOR_TASK_SCHEDULER;
    private static ReentrantLock SCHEDULER_CHANGE_LOCK;
    private static List<MultipleFilesChangeMonitor> MONITOR_INSTANCES;
    private long lastCheckTimestamp = 0L;
    private final long watchingPeriodInSec;
    private List<WatchedFile> watchedFiles = new ArrayList<WatchedFile>();
    private FilesChangedNotifier notifier;

    public MultipleFilesChangeMonitor(long watchingPeriodInSec, FilesChangedNotifier notifier, String ... files) {
        this.watchingPeriodInSec = watchingPeriodInSec;
        this.notifier = notifier;
        for (String file : files) {
            WatchedFile monitor = StringUtil.isEmpty(file) ? new NoopWatchedFile() : new WatchedFile(file);
            this.watchedFiles.add(monitor);
        }
    }

    private void checkAndNotify() {
        if (System.currentTimeMillis() - this.lastCheckTimestamp < this.watchingPeriodInSec * 1000L) {
            return;
        }
        boolean isChanged = false;
        for (WatchedFile watchedFile : this.watchedFiles) {
            isChanged = isChanged || watchedFile.detectContentChanged();
        }
        if (isChanged) {
            ArrayList<byte[]> contents = new ArrayList<byte[]>(this.watchedFiles.size());
            this.watchedFiles.forEach(file -> contents.add(file.fileContent));
            try {
                this.notifier.filesChanged(contents);
            }
            catch (Exception e) {
                log.error("Files=" + this + " notification process failure.", (Throwable)e);
            }
        }
    }

    public static void scanChanges() {
        MONITOR_INSTANCES.forEach(group -> {
            try {
                group.checkAndNotify();
            }
            catch (Throwable t) {
                log.error("Files change detection failure, gourp = ", t);
            }
        });
    }

    public void start() {
        SCHEDULER_CHANGE_LOCK.lock();
        try {
            if (FILE_MONITOR_TASK_SCHEDULER == null) {
                FILE_MONITOR_TASK_SCHEDULER = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(MultipleFilesChangeMonitor::scanChanges, 1L, 200L, TimeUnit.MILLISECONDS);
            }
            if (MONITOR_INSTANCES.contains(this)) {
                throw new IllegalStateException("This FileChangeMonitor has been started.");
            }
            this.checkAndNotify();
            MONITOR_INSTANCES.add(this);
        }
        finally {
            SCHEDULER_CHANGE_LOCK.unlock();
        }
    }

    public void stop() {
        SCHEDULER_CHANGE_LOCK.lock();
        try {
            MONITOR_INSTANCES.remove(this);
        }
        finally {
            SCHEDULER_CHANGE_LOCK.unlock();
        }
    }

    public String toString() {
        return "MultipleFilesChangeMonitor{watchedFiles=" + this.watchedFiles + "}";
    }

    static {
        SCHEDULER_CHANGE_LOCK = new ReentrantLock();
        MONITOR_INSTANCES = new ArrayList<MultipleFilesChangeMonitor>();
    }

    public static interface FilesChangedNotifier {
        public void filesChanged(List<byte[]> var1) throws Exception;
    }

    private static class NoopWatchedFile
    extends WatchedFile {
        public NoopWatchedFile() {
            super(null);
        }

        @Override
        boolean detectContentChanged() {
            return false;
        }
    }

    private static class WatchedFile {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(WatchedFile.class);
        private final String filePath;
        private long lastModifiedTimestamp = 0L;
        private byte[] fileContent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean detectContentChanged() {
            block19: {
                File targetFile = new File(this.filePath);
                if (!targetFile.exists()) {
                    if (this.lastModifiedTimestamp == 0L) {
                        return false;
                    }
                    this.lastModifiedTimestamp = 0L;
                    return true;
                }
                long lastModified = targetFile.lastModified();
                if (lastModified != this.lastModifiedTimestamp) {
                    try {
                        FileInputStream fileInputStream;
                        block18: {
                            boolean bl;
                            fileInputStream = new FileInputStream(targetFile);
                            try {
                                int c;
                                byte[] b = new byte[1024];
                                ByteArrayOutputStream os = new ByteArrayOutputStream();
                                while ((c = fileInputStream.read(b)) != -1) {
                                    os.write(b, 0, c);
                                }
                                byte[] newContent = os.toByteArray();
                                if (Arrays.equals(newContent, this.fileContent)) break block18;
                                this.fileContent = newContent;
                                bl = true;
                            }
                            catch (Throwable throwable) {
                                try {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                catch (FileNotFoundException e) {
                                    log.error("The existed file turns to missing, watch file=" + this.filePath, (Throwable)e);
                                    break block19;
                                }
                                catch (IOException e) {
                                    log.error("Read file failure, watch file=" + this.filePath, (Throwable)e);
                                    break block19;
                                }
                            }
                            fileInputStream.close();
                            return bl;
                        }
                        boolean bl = false;
                        fileInputStream.close();
                        return bl;
                    }
                    finally {
                        this.lastModifiedTimestamp = lastModified;
                    }
                }
            }
            return false;
        }

        @Generated
        public WatchedFile(String filePath) {
            this.filePath = filePath;
        }
    }
}

