/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.auth;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AbstractAuthorizerWithHandlers;
import com.linecorp.armeria.server.auth.AuthorizationStatus;
import com.linecorp.armeria.server.auth.Authorizer;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

final class DelegatingHttpRequestAuthorizer<T>
extends AbstractAuthorizerWithHandlers<HttpRequest> {
    private final Function<? super RequestHeaders, @Nullable T> tokenExtractor;
    private final Authorizer<? super T> delegate;

    DelegatingHttpRequestAuthorizer(Function<? super RequestHeaders, @Nullable T> tokenExtractor, Authorizer<? super T> delegate) {
        this.tokenExtractor = Objects.requireNonNull(tokenExtractor, "tokenExtractor");
        this.delegate = Objects.requireNonNull(delegate, "authorizer");
    }

    @Override
    public CompletionStage<AuthorizationStatus> authorizeAndSupplyHandlers(ServiceRequestContext ctx, @Nullable HttpRequest request) {
        T token = this.tokenExtractor.apply(Objects.requireNonNull(request, "request").headers());
        return this.delegate.authorizeAndSupplyHandlers(ctx, token);
    }
}

