/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.annotation.Nullable;
import java.util.Objects;
import org.slf4j.Logger;

public enum LogLevel {
    OFF,
    TRACE,
    DEBUG,
    INFO,
    WARN,
    ERROR;


    public boolean isEnabled(Logger logger) {
        Objects.requireNonNull(logger, "logger");
        switch (this.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return logger.isTraceEnabled();
            }
            case 2: {
                return logger.isDebugEnabled();
            }
            case 3: {
                return logger.isInfoEnabled();
            }
            case 4: {
                return logger.isWarnEnabled();
            }
            case 5: {
                return logger.isErrorEnabled();
            }
        }
        throw new Error();
    }

    public void log(Logger logger, String message) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(message, "message");
        switch (this.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                logger.trace(message);
                break;
            }
            case 2: {
                logger.debug(message);
                break;
            }
            case 3: {
                logger.info(message);
                break;
            }
            case 4: {
                logger.warn(message);
                break;
            }
            case 5: {
                logger.error(message);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, @Nullable Object arg1) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(format, "format");
        if (arg1 instanceof Throwable) {
            this.log(logger, format, (Throwable)arg1);
            return;
        }
        switch (this.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                logger.trace(format, arg1);
                break;
            }
            case 2: {
                logger.debug(format, arg1);
                break;
            }
            case 3: {
                logger.info(format, arg1);
                break;
            }
            case 4: {
                logger.warn(format, arg1);
                break;
            }
            case 5: {
                logger.error(format, arg1);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void log(Logger logger, String format, Throwable throwable) {
        switch (this.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                logger.trace(format, throwable);
                break;
            }
            case 2: {
                logger.debug(format, throwable);
                break;
            }
            case 3: {
                logger.info(format, throwable);
                break;
            }
            case 4: {
                logger.warn(format, throwable);
                break;
            }
            case 5: {
                logger.error(format, throwable);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, @Nullable Object arg1, @Nullable Object arg2) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(format, "format");
        switch (this.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                logger.trace(format, arg1, arg2);
                break;
            }
            case 2: {
                logger.debug(format, arg1, arg2);
                break;
            }
            case 3: {
                logger.info(format, arg1, arg2);
                break;
            }
            case 4: {
                logger.warn(format, arg1, arg2);
                break;
            }
            case 5: {
                logger.error(format, arg1, arg2);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(format, "format");
        switch (this.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                logger.trace(format, new Object[]{arg1, arg2, arg3});
                break;
            }
            case 2: {
                logger.debug(format, new Object[]{arg1, arg2, arg3});
                break;
            }
            case 3: {
                logger.info(format, new Object[]{arg1, arg2, arg3});
                break;
            }
            case 4: {
                logger.warn(format, new Object[]{arg1, arg2, arg3});
                break;
            }
            case 5: {
                logger.error(format, new Object[]{arg1, arg2, arg3});
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void log(Logger logger, String format, Object ... args) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(format, "format");
        switch (this.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                logger.trace(format, args);
                break;
            }
            case 2: {
                logger.debug(format, args);
                break;
            }
            case 3: {
                logger.info(format, args);
                break;
            }
            case 4: {
                logger.warn(format, args);
                break;
            }
            case 5: {
                logger.error(format, args);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }
}

