/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientPreprocessors;
import com.linecorp.armeria.client.HttpPreprocessor;
import com.linecorp.armeria.client.RpcPreprocessor;
import com.linecorp.armeria.common.annotation.UnstableApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@UnstableApi
public final class ClientPreprocessorsBuilder {
    private final List<HttpPreprocessor> preprocessors = new ArrayList<HttpPreprocessor>();
    private final List<RpcPreprocessor> rpcPreprocessors = new ArrayList<RpcPreprocessor>();

    ClientPreprocessorsBuilder() {
    }

    public ClientPreprocessorsBuilder add(ClientPreprocessors preprocessors) {
        Objects.requireNonNull(preprocessors, "preprocessors");
        preprocessors.preprocessors().forEach(this::add);
        preprocessors.rpcPreprocessors().forEach(this::addRpc);
        return this;
    }

    public ClientPreprocessorsBuilder add(HttpPreprocessor preprocessor) {
        this.preprocessors.add(Objects.requireNonNull(preprocessor, "preprocessor"));
        return this;
    }

    public ClientPreprocessorsBuilder addRpc(RpcPreprocessor rpcPreprocessor) {
        this.rpcPreprocessors.add(Objects.requireNonNull(rpcPreprocessor, "rpcPreprocessor"));
        return this;
    }

    public ClientPreprocessors build() {
        return new ClientPreprocessors(this.preprocessors, this.rpcPreprocessors);
    }
}

