/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.configmap;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.FetchingConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.api.GroupConfigTable;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigmapConfigurationSettings;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigurationConfigmapInformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigmapConfigurationWatcherRegister
extends FetchingConfigWatcherRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigmapConfigurationWatcherRegister.class);
    private final ConfigurationConfigmapInformer informer;

    public ConfigmapConfigurationWatcherRegister(ConfigmapConfigurationSettings settings, ConfigurationConfigmapInformer informer) {
        super((long)settings.getPeriod().intValue());
        this.informer = informer;
    }

    public Optional<ConfigTable> readConfig(Set<String> keys) {
        ConfigTable configTable = new ConfigTable();
        Map<String, String> configMapData = this.informer.configMapData();
        for (String name : keys) {
            String value = configMapData.get(name);
            if (log.isDebugEnabled()) {
                log.debug("read config: name:{} ,value:{}", (Object)name, (Object)value);
            }
            configTable.add(new ConfigTable.ConfigItem(name, value));
        }
        return Optional.of(configTable);
    }

    public Optional<GroupConfigTable> readGroupConfig(Set<String> keys) {
        GroupConfigTable groupConfigTable = new GroupConfigTable();
        Map<String, String> configMapData = this.informer.configMapData();
        keys.forEach(key -> {
            GroupConfigTable.GroupConfigItems groupConfigItems = new GroupConfigTable.GroupConfigItems(key);
            groupConfigTable.addGroupConfigItems(groupConfigItems);
            configMapData.forEach((groupItemKey, itemValue) -> {
                if (groupItemKey.startsWith(key + ".")) {
                    String itemName = groupItemKey.substring(key.length() + 1);
                    groupConfigItems.add(new ConfigTable.ConfigItem(itemName, itemValue));
                }
            });
        });
        return Optional.of(groupConfigTable);
    }
}

