/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.query.AsyncProfilerTaskLog;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTaskLogOperationType;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskLogQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class AsyncProfilerTaskLogQueryEsDAO
extends EsDAO
implements IAsyncProfilerTaskLogQueryDAO {
    private final int queryMaxSize;

    public AsyncProfilerTaskLogQueryEsDAO(ElasticSearchClient client, int queryMaxSize) {
        super(client);
        this.queryMaxSize = queryMaxSize * 50;
    }

    public List<AsyncProfilerTaskLog> getTaskLogList() throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("async_profiler_task_log");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("async_profiler_task_log")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"async_profiler_task_log"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).sort("operation_time", Sort.Order.DESC).size(Integer.valueOf(this.queryMaxSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        LinkedList<AsyncProfilerTaskLog> tasks = new LinkedList<AsyncProfilerTaskLog>();
        for (SearchHit searchHit : response.getHits().getHits()) {
            tasks.add(this.buildAsyncProfilerTaskLog(searchHit));
        }
        return tasks;
    }

    private AsyncProfilerTaskLog buildAsyncProfilerTaskLog(SearchHit data) {
        Map source = data.getSource();
        int operationTypeInt = ((Number)source.get("operation_type")).intValue();
        AsyncProfilerTaskLogOperationType operationType = AsyncProfilerTaskLogOperationType.parse((int)operationTypeInt);
        return AsyncProfilerTaskLog.builder().id((String)source.get("task_id")).instanceId((String)source.get("instance_id")).operationType(operationType).operationTime(((Number)source.get("operation_time")).longValue()).build();
    }
}

