/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.IdsQuery;
import org.apache.skywalking.library.elasticsearch.requests.search.MatchPhaseQuery;
import org.apache.skywalking.library.elasticsearch.requests.search.MatchQuery;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.RangeQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.TermQuery;
import org.apache.skywalking.library.elasticsearch.requests.search.TermsQuery;

public abstract class Query
implements QueryBuilder {
    @Override
    public Query build() {
        return this;
    }

    public static RangeQueryBuilder range(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        return new RangeQueryBuilder(name);
    }

    public static TermQuery term(String name, Object value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        Objects.requireNonNull(value, "value");
        return new TermQuery(name, value);
    }

    public static TermsQuery terms(String name, Object ... values) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        Objects.requireNonNull(values, "values");
        return new TermsQuery(name, Arrays.asList(values));
    }

    public static TermsQuery terms(String name, List<?> values) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        Objects.requireNonNull(values, "values");
        return new TermsQuery(name, values);
    }

    public static MatchQuery match(String name, String text) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)text) ? 1 : 0) != 0, (Object)"text cannot be blank");
        return new MatchQuery(name, text);
    }

    public static MatchQuery match(String name, Object value) {
        Objects.requireNonNull(value, "value");
        return Query.match(name, value.toString());
    }

    public static MatchPhaseQuery matchPhrase(String name, String text) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be blank");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)text) ? 1 : 0) != 0, (Object)"text cannot be blank");
        return new MatchPhaseQuery(name, text);
    }

    public static IdsQuery ids(String ... ids) {
        Objects.requireNonNull(ids, "ids");
        Preconditions.checkArgument((ids.length > 0 ? 1 : 0) != 0, (Object)"ids cannot be empty");
        return Query.ids(Arrays.asList(ids));
    }

    public static IdsQuery ids(Iterable<String> ids) {
        Objects.requireNonNull(ids, "ids");
        return new IdsQuery((ImmutableList<String>)ImmutableList.builder().addAll(ids).build());
    }

    public static BoolQueryBuilder bool() {
        return new BoolQueryBuilder();
    }
}

