/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.v7plus;

import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.MediaType;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.requests.factory.TemplateFactory;
import org.apache.skywalking.library.elasticsearch.response.Mappings;

final class V78TemplateFactory
implements TemplateFactory {
    private final ElasticSearchVersion version;

    @Override
    public HttpRequest exists(String name) {
        return HttpRequest.builder().get("/_index_template/{name}").pathParam("name", (Object)name).build();
    }

    @Override
    public HttpRequest get(String name) {
        return HttpRequest.builder().get("/_index_template/{name}").pathParam("name", (Object)name).build();
    }

    @Override
    public HttpRequest delete(String name) {
        return HttpRequest.builder().delete("/_index_template/{name}").pathParam("name", (Object)name).build();
    }

    @Override
    public HttpRequest createOrUpdate(String name, Map<String, ?> settings, Mappings mappings, int order) {
        String[] patterns = new String[]{name + "-*"};
        ImmutableMap aliases = ImmutableMap.of((Object)name, Collections.emptyMap());
        ImmutableMap template = ImmutableMap.builder().put((Object)"index_patterns", (Object)patterns).put((Object)"template", (Object)ImmutableMap.builder().put((Object)"aliases", (Object)aliases).put((Object)"settings", settings).put((Object)"mappings", (Object)mappings).build()).build();
        byte[] content = this.version.codec().encode(template);
        return HttpRequest.builder().put("/_index_template/{name}").pathParam("name", (Object)name).content(MediaType.JSON, content).build();
    }

    @Generated
    public V78TemplateFactory(ElasticSearchVersion version) {
        this.version = version;
    }
}

