/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.Definition;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Node;
import graphql.validation.AbstractRule;
import graphql.validation.DocumentVisitor;
import graphql.validation.LanguageTraversal;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class NoFragmentCycles
extends AbstractRule {
    private final Map<String, Set<String>> fragmentSpreads = new HashMap<String, Set<String>>();

    public NoFragmentCycles(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
        this.prepareFragmentMap();
    }

    private void prepareFragmentMap() {
        List<Definition> definitions = this.getValidationContext().getDocument().getDefinitions();
        for (Definition definition : definitions) {
            if (!(definition instanceof FragmentDefinition)) continue;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)definition;
            this.fragmentSpreads.put(fragmentDefinition.getName(), this.gatherSpreads(fragmentDefinition));
        }
    }

    private Set<String> gatherSpreads(FragmentDefinition fragmentDefinition) {
        final HashSet<String> fragmentSpreads = new HashSet<String>();
        DocumentVisitor visitor = new DocumentVisitor(){

            @Override
            public void enter(Node node, List<Node> path) {
                if (node instanceof FragmentSpread) {
                    fragmentSpreads.add(((FragmentSpread)node).getName());
                }
            }

            @Override
            public void leave(Node node, List<Node> path) {
            }
        };
        new LanguageTraversal().traverse(fragmentDefinition, visitor);
        return fragmentSpreads;
    }

    @Override
    public void checkFragmentDefinition(FragmentDefinition fragmentDefinition) {
        LinkedList<String> path = new LinkedList<String>();
        path.add(0, fragmentDefinition.getName());
        Map<String, Set<String>> transitiveSpreads = this.buildTransitiveSpreads(path, new HashMap<String, Set<String>>());
        for (Map.Entry<String, Set<String>> entry : transitiveSpreads.entrySet()) {
            if (!entry.getValue().contains(entry.getKey())) continue;
            String message = this.i18n(ValidationErrorType.FragmentCycle, "NoFragmentCycles.cyclesNotAllowed", new Object[0]);
            this.addError(ValidationErrorType.FragmentCycle, Collections.singletonList(fragmentDefinition), message);
        }
    }

    private Map<String, Set<String>> buildTransitiveSpreads(LinkedList<String> path, Map<String, Set<String>> transitiveSpreads) {
        String name = path.peekFirst();
        if (transitiveSpreads.containsKey(name)) {
            return transitiveSpreads;
        }
        Set<String> spreads = this.fragmentSpreads.get(name);
        if (spreads == null || spreads.isEmpty()) {
            return transitiveSpreads;
        }
        for (String ancestor : path) {
            Set<String> ancestorSpreads = transitiveSpreads.get(ancestor);
            if (ancestorSpreads == null) {
                ancestorSpreads = new HashSet<String>();
            }
            ancestorSpreads.addAll(spreads);
            transitiveSpreads.put(ancestor, ancestorSpreads);
        }
        for (String child : spreads) {
            if (path.contains(child) || transitiveSpreads.containsKey(child)) continue;
            LinkedList<String> childPath = new LinkedList<String>(path);
            childPath.add(0, child);
            this.buildTransitiveSpreads(childPath, transitiveSpreads);
        }
        return transitiveSpreads;
    }
}

