/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.MergedField;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class MergedSelectionSet {
    private final ImmutableMap<String, MergedField> subFields;

    private MergedSelectionSet(Map<String, MergedField> subFields) {
        this.subFields = ImmutableMap.copyOf(Assert.assertNotNull(subFields));
    }

    public Map<String, MergedField> getSubFields() {
        return this.subFields;
    }

    public List<MergedField> getSubFieldsList() {
        return ImmutableList.copyOf(this.subFields.values());
    }

    public int size() {
        return this.subFields.size();
    }

    public Set<String> keySet() {
        return this.subFields.keySet();
    }

    public MergedField getSubField(String key) {
        return this.subFields.get(key);
    }

    public List<String> getKeys() {
        return ImmutableList.copyOf(this.keySet());
    }

    public boolean isEmpty() {
        return this.subFields.isEmpty();
    }

    public static Builder newMergedSelectionSet() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, MergedField> subFields = ImmutableMap.of();

        private Builder() {
        }

        public Builder subFields(Map<String, MergedField> subFields) {
            this.subFields = subFields;
            return this;
        }

        public MergedSelectionSet build() {
            return new MergedSelectionSet(this.subFields);
        }
    }
}

